<?php

use CodeIgniter\Router\RouteCollection;

/** @var RouteCollection $routes */

$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('AuthController');
$routes->setDefaultMethod('login');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(false);

/*
|----------------------------------------------------------------------
| Authentication
|----------------------------------------------------------------------
*/
$routes->get('/', 'AuthController::login');
$routes->get('/login', 'AuthController::login');
$routes->post('/loginAuth', 'AuthController::loginAuth');
$routes->get('/logout', 'AuthController::logout');

/*
|----------------------------------------------------------------------
| Dashboard
|----------------------------------------------------------------------
*/
$routes->get('/dashboard', 'DashboardController::index');

/*
|----------------------------------------------------------------------
| Users Management
|----------------------------------------------------------------------
*/
$routes->get('/users', 'UsersController::index');
$routes->post('/users/store', 'UsersController::store');
$routes->post('/users/update/(:num)', 'UsersController::update/$1');
$routes->get('/users/delete/(:num)', 'UsersController::delete/$1');

/*
|----------------------------------------------------------------------
| Vendors Management
|----------------------------------------------------------------------
*/
$routes->get('/vendors', 'VendorsController::index');
$routes->post('/vendors/store', 'VendorsController::store');
$routes->get('/vendors/delete/(:num)', 'VendorsController::delete/$1');
$routes->get('/vendors/view/(:num)', 'VendorsController::view/$1');
$routes->get('vendors/download', 'VendorsController::download');

/*
|----------------------------------------------------------------------
| Products Management
|----------------------------------------------------------------------
*/
$routes->get('products', 'ProductsController::index');
$routes->post('products/store', 'ProductsController::store');
$routes->get('products/view/(:num)', 'ProductsController::view/$1');
$routes->get('products/delete/(:num)', 'ProductsController::delete/$1');
$routes->get('products/edit/(:num)', 'ProductsController::edit/$1');
$routes->post('products/update/(:num)', 'ProductsController::update/$1');

/*
|----------------------------------------------------------------------
| Purchases Management
|----------------------------------------------------------------------
*/
$routes->get('purchases', 'PurchaseController::index');
$routes->post('purchases/store', 'PurchaseController::store');
$routes->get('purchases/edit/(:num)', 'PurchaseController::edit/$1');
$routes->post('purchases/update/(:num)', 'PurchaseController::update/$1');
$routes->get('purchases/delete/(:num)', 'PurchaseController::delete/$1');

/*
|----------------------------------------------------------------------
| Payments Management
|----------------------------------------------------------------------
*/
$routes->get('payments', 'PaymentController::index');
$routes->post('payments/store', 'PaymentController::store');
$routes->get('payments/delete/(:num)', 'PaymentController::delete/$1');
$routes->get('payments/downloadPdf', 'PaymentController::downloadPdf');
$routes->get('payments/download/pdf', 'PaymentController::downloadPdf');
$routes->get('payments/vendorItems/(:num)', 'PaymentController::vendorItems/$1');

/*
|----------------------------------------------------------------------
| Customers Management
|----------------------------------------------------------------------
*/
$routes->get('customer', 'CustomersController::index');   // singular
$routes->get('customers', 'CustomersController::index');  // plural
$routes->post('customers/store', 'CustomersController::store');
$routes->get('customers/delete/(:num)', 'CustomersController::delete/$1');
$routes->get('customers/view/(:num)', 'CustomersController::view/$1');
$routes->post('customers/update/(:num)', 'CustomersController::update/$1');
$routes->post('customers/update', 'CustomersController::update');

/*
|----------------------------------------------------------------------
| Sales Management
|----------------------------------------------------------------------
*/
$routes->get('sales', 'SalesController::index');
$routes->post('sales/store', 'SalesController::store');
$routes->get('sales/view/(:num)', 'SalesController::view/$1');
$routes->get('sales/delete/(:num)', 'SalesController::delete/$1');
$routes->get('sales/edit/(:num)', 'SalesController::edit/$1');
$routes->post('sales/update/(:num)', 'SalesController::update/$1');

/* Invoice routes */
$routes->get('sales/invoice/(:num)', 'SalesController::generateInvoice/$1'); // specific invoice
$routes->get('sales/invoice', 'SalesController::latestInvoice');             // latest invoice
$routes->get('sales/latest-invoice', 'SalesController::latestInvoice');
$routes->get('sales/generateInvoice', 'SalesController::generateInvoice');
$routes->get('sales/downloadInvoice/(:num)', 'SalesController::downloadInvoice/$1');

/*
|----------------------------------------------------------------------
| Sales Payments
|----------------------------------------------------------------------
*/
$routes->get('sales-payments', 'SalesPaymentController::index');
$routes->post('sales-payments/store', 'SalesPaymentController::store');
$routes->get('sales-payments/delete/(:num)', 'SalesPaymentController::delete/$1');

/*
|----------------------------------------------------------------------
| Accounts
|----------------------------------------------------------------------
*/
$routes->get('accounts', 'AccountController::index');
$routes->post('accounts/store', 'AccountController::store');
$routes->get('accounts/delete/(:num)', 'AccountController::delete/$1');

/*
|----------------------------------------------------------------------
| Daily Money
|----------------------------------------------------------------------
*/
$routes->get('daily-money', 'DailyMoneyController::index');
$routes->post('daily-money/store', 'DailyMoneyController::store');
$routes->get('daily-money/delete/(:num)', 'DailyMoneyController::delete/$1');

/*
|----------------------------------------------------------------------
| My Daily Money
|----------------------------------------------------------------------
*/
$routes->get('my-daily-money', 'MyDailyMoneyController::index');
$routes->post('my-daily-money/store', 'MyDailyMoneyController::store');

/*
|----------------------------------------------------------------------
| User Dashboard
|----------------------------------------------------------------------
*/

$routes->get('reports', 'Reports::index');           // main reports page
$routes->get('reports/profit', 'Reports::profit');   // profit report

$routes->get('sales-payments/downloadPdf', 'SalesPaymentController::downloadPdf');
$routes->get('sales-payments/view/(:num)', 'SalesPaymentController::view/$1');

$routes->get('reports/sales', 'Reports::salesReport');
$routes->get('reports/purchases', 'Reports::purchases');


$routes->get('assets', 'AssetsController::index');
$routes->post('assets/store', 'AssetsController::store');
$routes->get('assets/delete/(:num)', 'AssetsController::delete/$1');

$routes->get('users/ban/(:num)', 'UsersController::ban/$1');
$routes->get('users/unban/(:num)', 'UsersController::unban/$1');