<?php

namespace App\Controllers;

use App\Models\AccountModel;

class AccountController extends BaseController
{
    protected $accountModel;
    protected $session;

    public function __construct()
    {
        $this->accountModel = new AccountModel();
        $this->session = session();
    }

    // Auth check
    private function checkAuth()
    {
        if (!$this->session->get('logged_in')) {
            return redirect()->to('/login')->send();
        }
    }

    // Show accounts
    public function index()
    {
        $this->checkAuth();

        $accounts = $this->accountModel->findAll();

        return view('accounts/index', [
            'accounts' => $accounts
        ]);
    }

    // Save multiple accounts at once
    public function store()
    {
        $this->checkAuth();

        $rows = $this->request->getPost('rows');

        if ($rows) {
            foreach ($rows as $row) {
                if (!empty($row['name']) && !empty($row['type'])) {
                    $this->accountModel->save([
                        'name' => $row['name'],
                        'type' => $row['type'],
                        'description' => $row['description'] ?? ''
                    ]);
                }
            }
        }

        return redirect()->to(site_url('accounts'))->with('success', 'Accounts saved successfully.');
    }

    // Delete an account
    public function delete($id)
    {
        $this->checkAuth();

        $this->accountModel->delete($id);
        return redirect()->to(site_url('accounts'))->with('success', 'Account deleted.');
    }

    // Optional: Edit/Update an account
    public function update($id)
    {
        $this->checkAuth();

        $data = [
            'name' => $this->request->getPost('name'),
            'type' => $this->request->getPost('type'),
            'description' => $this->request->getPost('description')
        ];

        $this->accountModel->update($id, $data);
        return redirect()->to(site_url('accounts'))->with('success', 'Account updated.');
    }
}
