<?php

namespace App\Controllers;

use App\Models\AssetsModel;

class AssetsController extends BaseController
{
    protected $assetsModel;

    public function __construct()
    {
        $this->assetsModel = new AssetsModel();
    }

    // Display all assets
    public function index()
    {
        $data['assets'] = $this->assetsModel->orderBy('id', 'DESC')->findAll();
        return view('assets/index', $data);
    }

    // Store a new asset
    public function store()
    {
        $validation = \Config\Services::validation();

        $rules = [
            'asset_name'  => 'required|max_length[100]',
            'description' => 'permit_empty|max_length[255]',
            'asset_value' => 'required|decimal',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $validation->getErrors());
        }

        $this->assetsModel->save([
            'asset_name'  => $this->request->getPost('asset_name'),
            'description' => $this->request->getPost('description'),
            'asset_value' => $this->request->getPost('asset_value'),
        ]);

        return redirect()->to(site_url('assets'))->with('success', 'Asset added successfully.');
    }

    // Delete an asset
    public function delete($id)
    {
        $this->assetsModel->delete($id);
        return redirect()->to(site_url('assets'))->with('success', 'Asset deleted successfully.');
    }
}
