<?php

namespace App\Controllers;

use App\Models\DailyMoneyModel;
use App\Models\AccountModel;

class DailyMoneyController extends BaseController
{
    public function index()
    {
        $moneyModel   = new DailyMoneyModel();
        $accountModel = new AccountModel();
        $request      = $this->request;

        // 🔍 Global search input
        $search = trim($request->getGet('search'));

        $builder = $moneyModel
            ->select('daily_money.*, accounts.name as account_name')
            ->join('accounts', 'accounts.id = daily_money.account_id', 'left');

        /**
         * Global search across multiple columns
         */
        if (!empty($search)) {
            $builder->groupStart()
                ->like('daily_money.entry_date', $search)
                ->orLike('accounts.name', $search)
                ->orLike('daily_money.type', $search)
                ->orLike('daily_money.description', $search)
                ->orLike('daily_money.amount', $search)
            ->groupEnd();
        }

        $data = [
            'records'  => $builder
                ->orderBy('daily_money.entry_date', 'DESC')
                ->findAll(),

            'accounts' => $accountModel->findAll(),

            // pass back search value
            'search'   => $search,
        ];

        return view('daily_money/index', $data);
    }

    public function store()
    {
        $model   = new DailyMoneyModel();
        $request = $this->request;

        $entryDate = $request->getPost('rows_date') ?: date('Y-m-d');
        $rows      = $request->getPost('rows');

        if (is_array($rows)) {
            foreach ($rows as $row) {
                if (
                    empty($row['account_id']) ||
                    empty($row['type']) ||
                    empty($row['amount'])
                ) {
                    continue;
                }

                $model->insert([
                    'account_id'  => $row['account_id'],
                    'entry_date'  => $entryDate,
                    'type'        => $row['type'],
                    'description' => $row['description'] ?? null,
                    'amount'      => $row['amount'],
                ]);
            }
        }

        return redirect()->to(site_url('daily-money'));
    }

    public function delete($id)
    {
        (new DailyMoneyModel())->delete($id);
        return redirect()->to(site_url('daily-money'));
    }
}
