<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\UserModel;

class DashboardController extends Controller
{
    public function index()
{
    $session = session();

    if (!$session->get('logged_in')) {
        return redirect()->to('/login');
    }

    // 🚫 FORCE NO CACHE (this is the key)
    $this->response
        ->setHeader('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0')
        ->setHeader('Cache-Control', 'post-check=0, pre-check=0', false)
        ->setHeader('Pragma', 'no-cache')
        ->setHeader('Expires', '0');

    $data = [
        'name' => $session->get('name'),
        'role' => $session->get('role'),
    ];

    if ($session->get('role') === 'manager') {
        $userModel = new \App\Models\UserModel();
        $data['totalUsers'] = $userModel->countAllResults();
    }

    return view('dashboard', $data);
}

}
