<?php

namespace App\Controllers;

use App\Models\MyDailyMoneyModel;

class MyDailyMoneyController extends BaseController
{
    public function index()
    {
        $model = new MyDailyMoneyModel();

        $summary = $model->getTodaySummary();

        $data = [
            'entries'       => $model->orderBy('created_at', 'DESC')->findAll(),
            'todayIncome'   => $summary['income'],
            'todayExpense'  => $summary['expense'],
            'todayBalance'  => $summary['balance'],
        ];

        return view('admin/my_daily_money', $data);
    }

    public function store()
    {
        $model = new MyDailyMoneyModel();

        $model->insert([
            'type'        => $this->request->getPost('type'),
            'description' => $this->request->getPost('description'),
            'amount'      => $this->request->getPost('amount'),
            'created_at'  => date('Y-m-d H:i:s'),
        ]);

        return redirect()->to('my-daily-money');
    }
}
