<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\UserModel;

class UsersController extends Controller
{
    protected $userModel;
    protected $session;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->session = session();
    }

    private function checkAuth()
    {
        if (!$this->session->get('logged_in')) {
            return redirect()->to('/login')->send();
        }
    }

    // List users
    public function index()
    {
        $this->checkAuth();
        $data['users'] = $this->userModel->findAll();
        return view('users/index', $data);
    }

    // Store new user
    public function store()
    {
        $this->checkAuth();

        $data = [
            'name'     => $this->request->getVar('name'),
            'email'    => $this->request->getVar('email'),
            'role'     => $this->request->getVar('role'),
            'status'   => 'active',
            'password' => md5($this->request->getVar('password'))
        ];

        $this->userModel->insert($data);
        return redirect()->to('/users')->with('success', 'User added successfully.');
    }

    // Update user
    public function update($id)
    {
        $this->checkAuth();

        $data = [
            'name' => $this->request->getVar('name'),
            'email' => $this->request->getVar('email'),
            'role' => $this->request->getVar('role')
        ];

        $password = $this->request->getVar('password');
        if (!empty($password)) {
            $data['password'] = md5($password);
        }

        if (!empty($data)) {
            $this->userModel->update($id, $data);
            return redirect()->to('/users')->with('success', 'User updated successfully.');
        }

        return redirect()->to('/users')->with('error', 'No data to update.');
    }

    // Delete user
    public function delete($id)
    {
        $this->checkAuth();
        $this->userModel->delete($id);
        return redirect()->to('/users')->with('success', 'User deleted successfully.');
    }

    // Ban user (only normal users)
    public function ban($id)
    {
        $this->checkAuth();

        if ($id == $this->session->get('user_id')) {
            return redirect()->to('/users')->with('error', 'You cannot ban yourself.');
        }

        $user = $this->userModel->find($id);
        if (!$user) return redirect()->to('/users')->with('error', 'User not found.');
        if ($user['role'] === 'manager') return redirect()->to('/users')->with('error', 'Managers cannot be banned.');

        $this->userModel->update($id, ['status' => 'banned']);
        return redirect()->to('/users')->with('success', 'User banned successfully.');
    }

    // Unban user
    public function unban($id)
    {
        $this->checkAuth();

        $user = $this->userModel->find($id);
        if (!$user) return redirect()->to('/users')->with('error', 'User not found.');
        if ($user['role'] === 'manager') return redirect()->to('/users')->with('error', 'Managers cannot be unbanned.');

        $this->userModel->update($id, ['status' => 'active']);
        return redirect()->to('/users')->with('success', 'User unbanned successfully.');
    }
}
