<?php

namespace App\Models;

use CodeIgniter\Model;

class MyDailyMoneyModel extends Model
{
    protected $table = 'my_daily_money';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'type',        // income | expense
        'description',
        'amount',
        'created_at'
    ];

    protected $useTimestamps = false;

    public function getTodaySummary()
    {
        $today = date('Y-m-d');

        $income = $this->selectSum('amount')
            ->where('type', 'income')
            ->where('DATE(created_at)', $today)
            ->get()->getRow()->amount ?? 0;

        $expense = $this->selectSum('amount')
            ->where('type', 'expense')
            ->where('DATE(created_at)', $today)
            ->get()->getRow()->amount ?? 0;

        return [
            'income'  => $income,
            'expense' => $expense,
            'balance' => $income - $expense
        ];
    }
}
