<?php

namespace App\Models;

use CodeIgniter\Model;

class SaleModel extends Model
{
    protected $table = 'sales';
    protected $primaryKey = 'id';
    protected $allowedFields = ['customer_id', 'product_id', 'quantity', 'price'];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    /**
     * Get sale by ID including customer info
     */
    public function getSaleById($id)
    {
        $builder = $this->db->table('sales as s');
        $builder->select('s.id, s.customer_id, s.product_id, s.quantity, s.price, s.created_at, c.name as customer_name, c.phone, c.address, p.name as product_name');
        $builder->join('customers as c', 'c.id = s.customer_id');
        $builder->join('products as p', 'p.id = s.product_id');
        $builder->where('s.id', $id);

        $query = $builder->get();
        return $query->getResultArray();
    }

    public function getInvoiceSales($customerId, $createdAt)
{
    $builder = $this->db->table('sales as s');
    $builder->select('
        s.id,
        s.customer_id,
        s.product_id,
        s.quantity,
        s.price,
        s.created_at,
        c.name as customer_name,
        c.phone,
        c.address,
        p.name as product_name
    ');
    $builder->join('customers as c', 'c.id = s.customer_id');
    $builder->join('products as p', 'p.id = s.product_id');

    $builder->where('s.customer_id', $customerId);
    $builder->where('DATE(s.created_at)', date('Y-m-d', strtotime($createdAt)));

    return $builder->get()->getResultArray();
}

}
