<?= $this->extend('layout') ?>
<?= $this->section('content') ?>

<!-- Page Header -->
<div class="flex items-center justify-between mb-6 flex-wrap gap-4">
    <div class="flex items-center gap-4">
        <!-- Back button on left -->
        <a href="<?= site_url('daily-money') ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
    ← Back
</a>

        <h1 class="text-2xl font-semibold">Accounts</h1>
    </div>
    <!-- Add Accounts button -->
    <button id="openModal" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
        Add Accounts
    </button>
</div>

<!-- Accounts Modal -->
<div id="accountModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-xl p-6 w-full max-w-2xl relative">
        <h2 class="text-lg font-medium mb-4">Add New Accounts</h2>
        <button id="closeModal" class="absolute top-4 right-4 text-gray-500 text-xl">&times;</button>

        <form action="<?= site_url('accounts/store') ?>" method="post" id="accountsForm">
            <table class="w-full text-sm mb-4" id="accountsTable">
                <thead>
                    <tr>
                        <th class="px-3 py-2">Name</th>
                        <th class="px-3 py-2">Type</th>
                        <th class="px-3 py-2">Description</th>
                        <th class="px-3 py-2 text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="rowTemplate">
                        <td class="px-3 py-2">
                            <input type="text" name="rows[0][name]" required class="border rounded px-2 py-1 w-full" placeholder="Account Name">
                        </td>
                        <td class="px-3 py-2">
                            <select name="rows[0][type]" required class="border rounded px-2 py-1 w-full">
                                <option value="">Select Type</option>
                                <option value="income">Income</option>
                                <option value="expense">Expense</option>
                            </select>
                        </td>
                        <td class="px-3 py-2">
                            <input type="text" name="rows[0][description]" class="border rounded px-2 py-1 w-full" placeholder="Optional description">
                        </td>
                        <td class="px-3 py-2 text-center">
                            <button type="button" class="removeRow text-red-600 text-lg">&times;</button>
                        </td>
                    </tr>
                </tbody>
            </table>

            <div class="flex justify-between">
                <button type="button" id="addRow" class="bg-gray-200 hover:bg-gray-300 px-4 py-1.5 rounded">
                    Add Row
                </button>
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
                    Save Accounts
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Accounts Table -->
<div class="bg-white rounded-xl shadow border overflow-x-auto mt-6">
    <table class="w-full text-sm min-w-[600px]">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3">Name</th>
                <th class="px-6 py-3">Type</th>
                <th class="px-6 py-3">Description</th>
                <th class="px-6 py-3 text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($accounts)): ?>
                <?php foreach ($accounts as $acc): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-3"><?= esc($acc['name']) ?></td>
                        <td class="px-6 py-3"><?= ucfirst($acc['type']) ?></td>
                        <td class="px-6 py-3"><?= esc($acc['description']) ?></td>
                        <td class="px-6 py-3 text-center">
                            <a href="<?= site_url('accounts/delete/'.$acc['id']) ?>" class="text-red-600 hover:underline" onclick="return confirm('Delete this account?')">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="px-6 py-6 text-center text-gray-500">No accounts found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- JS -->
<script>
const modal = document.getElementById('accountModal');
const openBtn = document.getElementById('openModal');
const closeBtn = document.getElementById('closeModal');

openBtn.onclick = () => modal.classList.remove('hidden');
closeBtn.onclick = () => modal.classList.add('hidden');

document.getElementById('addRow').onclick = () => {
    const tbody = document.querySelector('#accountsTable tbody');
    const template = document.querySelector('.rowTemplate');
    const clone = template.cloneNode(true);

    clone.querySelectorAll('input, select').forEach(el => {
        el.name = el.name.replace(/\d+/, tbody.children.length);
        el.value = '';
    });

    clone.querySelector('.removeRow').onclick = () => clone.remove();
    tbody.appendChild(clone);
};

// Remove initial row
document.querySelectorAll('.removeRow').forEach(btn => {
    btn.onclick = (e) => e.target.closest('tr').remove();
});
</script>

<?= $this->endSection() ?>
