<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Daily Money</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto px-6 mt-6">

    <!-- BACK BUTTON -->
    <div class="mb-4">
        <a href="<?= site_url('dashboard') ?>" 
           class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            ← Back
        </a>
    </div>

    <h2 class="text-2xl font-bold mb-6">Company Daily Money</h2>

    <!-- SUMMARY CARDS -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
        <div class="bg-green-100 p-4 rounded">
            <p class="text-sm text-gray-600">Total Income</p>
            <p class="text-xl font-bold text-green-700" id="incomeCard">Tsh 0.00</p>
        </div>

        <div class="bg-red-100 p-4 rounded">
            <p class="text-sm text-gray-600">Total Expense</p>
            <p class="text-xl font-bold text-red-700" id="expenseCard">Tsh 0.00</p>
        </div>

        <div class="bg-blue-100 p-4 rounded">
            <p class="text-sm text-gray-600">Net Balance</p>
            <p class="text-xl font-bold text-blue-700" id="balanceCard">Tsh 0.00</p>
        </div>
    </div>

    <!-- ADD FORM -->
    <form action="<?= site_url('my-daily-money/store') ?>" method="post"
          class="bg-white p-4 rounded shadow mb-6 grid grid-cols-1 sm:grid-cols-4 gap-3">

        <select name="type" class="border px-3 py-2 rounded" required>
            <option value="">Type</option>
            <option value="income">Income</option>
            <option value="expense">Expense</option>
        </select>

        <input type="text" name="description"
               placeholder="Description"
               class="border px-3 py-2 rounded">

        <input type="number" name="amount" step="0.01"
               placeholder="Amount"
               class="border px-3 py-2 rounded" required>

        <button class="bg-blue-600 text-white px-4 py-2 rounded">
            Save
        </button>
    </form>

    <!-- SEARCH -->
    <div class="mb-4">
        <input type="text" id="searchInput" placeholder="Search by date, type, description, or amount..." 
               class="border px-3 py-2 rounded w-full sm:w-1/3"
               onkeyup="filterTable()">
    </div>

    <!-- TABLE -->
    <div class="bg-white rounded shadow overflow-hidden">
        <table class="w-full text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left">Date</th>
                    <th class="px-4 py-2 text-left">Type</th>
                    <th class="px-4 py-2 text-left">Description</th>
                    <th class="px-4 py-2 text-left">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($entries as $row): ?>
                    <tr class="border-t">
                        <td class="px-4 py-2"><?= date('Y-m-d', strtotime($row['created_at'])) ?></td>
                        <td class="px-4 py-2 capitalize"><?= esc($row['type']) ?></td>
                        <td class="px-4 py-2"><?= esc($row['description']) ?></td>
                        <td class="px-4 py-2">Tsh <?= number_format($row['amount'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<script>
function filterTable() {
    const input = document.getElementById('searchInput').value.toLowerCase();
    const table = document.querySelector('table tbody');
    const rows = table.getElementsByTagName('tr');

    let totalIncome = 0;
    let totalExpense = 0;

    for (let i = 0; i < rows.length; i++) {
        const cells = rows[i].getElementsByTagName('td');
        let match = false;

        // Check all cells for search term
        for (let j = 0; j < cells.length; j++) {
            if (cells[j].innerText.toLowerCase().includes(input)) {
                match = true;
                break;
            }
        }

        if (match) {
            rows[i].style.display = '';

            const type = cells[1].innerText.toLowerCase();
            const amountText = cells[3].innerText.replace(/Tsh|,/g, '');
            const amount = parseFloat(amountText) || 0;

            if (type === 'income') totalIncome += amount;
            else if (type === 'expense') totalExpense += amount;

        } else {
            rows[i].style.display = 'none';
        }
    }

    const balance = totalIncome - totalExpense;

    // Update summary cards
    document.getElementById('incomeCard').innerText = 'Tsh ' + totalIncome.toLocaleString(undefined, {minimumFractionDigits:2});
    document.getElementById('expenseCard').innerText = 'Tsh ' + totalExpense.toLocaleString(undefined, {minimumFractionDigits:2});
    document.getElementById('balanceCard').innerText = 'Tsh ' + balance.toLocaleString(undefined, {minimumFractionDigits:2});
}

// Initialize totals on page load
window.onload = filterTable;
</script>

</body>
</html>
