<?= $this->extend('layout'); ?>
<?= $this->section('content'); ?>

<!-- Header + Back Button -->
<div class="flex items-center justify-between mb-6 flex-wrap gap-4">
    <div class="flex items-center gap-4">
        <a href="<?= site_url('daily-money') ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Back
        </a>
        <h1 class="text-2xl font-bold text-gray-800">Manage Assets</h1>
    </div>
    <button id="openAssetModal" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
        Add New Asset
    </button>
</div>

<!-- Add Asset Modal -->
<div id="assetModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-xl p-6 w-full max-w-2xl relative">
        <h2 class="text-lg font-medium mb-4">Add New Asset</h2>
        <button id="closeAssetModal" class="absolute top-4 right-4 text-gray-500 text-xl">&times;</button>

        <form action="<?= site_url('assets/store') ?>" method="post" id="assetForm">
            <div class="mb-4">
                <label class="block text-sm mb-1">Asset Name</label>
                <input type="text" name="asset_name" class="w-full border rounded px-3 py-2" placeholder="Asset Name" required>
            </div>

            <div class="mb-4">
                <label class="block text-sm mb-1">Description</label>
                <textarea name="description" class="w-full border rounded px-3 py-2" placeholder="Optional description" rows="4"></textarea>
            </div>

            <div class="mb-4">
                <label class="block text-sm mb-1">Value</label>
                <input type="number" step="0.01" min="0" name="asset_value" class="w-full border rounded px-3 py-2" placeholder="Asset Value" required>
            </div>

            <div class="flex justify-end gap-2">
                <button type="button" id="closeAssetModalFooter" class="bg-gray-200 hover:bg-gray-300 px-4 py-2 rounded">Cancel</button>
                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded">Save Asset</button>
            </div>
        </form>
    </div>
</div>

<!-- Assets Table + Search -->
<div class="bg-white rounded-xl shadow border overflow-x-auto mt-6 p-4">
    <div class="flex justify-between items-center mb-4 flex-wrap gap-4">
        <input type="text" id="searchInput" placeholder="Search assets..." class="border rounded px-3 py-2 w-full md:w-1/3">
        <div class="text-right font-semibold text-lg">
            Total: $<span id="totalValue">0.00</span>
        </div>
    </div>

    <table class="w-full text-sm min-w-[600px]" id="assetsTable">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3">Name</th>
                <th class="px-6 py-3">Description</th>
                <th class="px-6 py-3 text-right">Value</th>
                <th class="px-6 py-3 text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $total = 0; ?>
            <?php if (!empty($assets)): ?>
                <?php foreach ($assets as $asset): ?>
                    <?php $total += $asset['asset_value']; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-3"><?= esc($asset['asset_name']) ?></td>
                        <td class="px-6 py-3"><?= esc($asset['description']) ?></td>
                        <td class="px-6 py-3 text-right asset-value"><?= number_format($asset['asset_value'], 2) ?></td>
                        <td class="px-6 py-3 text-center">
                            <a href="<?= site_url('assets/delete/'.$asset['id']) ?>" class="text-red-600 hover:underline" onclick="return confirm('Delete this asset?')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="px-6 py-6 text-center text-gray-500">No assets found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- JS -->
<script>
const assetModal = document.getElementById('assetModal');
document.getElementById('openAssetModal').onclick = () => assetModal.classList.remove('hidden');
document.getElementById('closeAssetModal').onclick = () => assetModal.classList.add('hidden');
document.getElementById('closeAssetModalFooter').onclick = () => assetModal.classList.add('hidden');

// Search functionality
const searchInput = document.getElementById('searchInput');
const tableBody = document.getElementById('assetsTable').getElementsByTagName('tbody')[0];

searchInput.addEventListener('keyup', function() {
    const filter = searchInput.value.toLowerCase();
    let total = 0;

    Array.from(tableBody.rows).forEach(row => {
        const name = row.cells[0].textContent.toLowerCase();
        const desc = row.cells[1].textContent.toLowerCase();
        const value = parseFloat(row.cells[2].textContent.replace(/,/g,'')) || 0;

        if (name.includes(filter) || desc.includes(filter)) {
            row.style.display = '';
            total += value;
        } else {
            row.style.display = 'none';
        }
    });

    document.getElementById('totalValue').textContent = total.toFixed(2);
});

// Calculate total on page load
document.addEventListener('DOMContentLoaded', () => {
    let total = 0;
    document.querySelectorAll('.asset-value').forEach(td => {
        total += parseFloat(td.textContent.replace(/,/g,'')) || 0;
    });
    document.getElementById('totalValue').textContent = total.toFixed(2);
});
</script>

<?= $this->endSection(); ?>
