<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manager Login</title>
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        /* Background animation */
        @keyframes gradientMove {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Card entrance */
        @keyframes slideFade {
            from { opacity: 0; transform: translateY(30px) scale(0.95); }
            to { opacity: 1; transform: translateY(0) scale(1); }
        }

        /* Logo pulse */
        @keyframes pulseSoft {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        /* Title animation */
        @keyframes titleFade {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-card {
            animation: slideFade 0.7s ease-out forwards;
        }

        .animate-logo {
            animation: pulseSoft 3s ease-in-out infinite;
        }

        .animate-title {
            animation: titleFade 0.8s ease-out forwards;
        }
    </style>
</head>

<body class="min-h-screen flex items-center justify-center px-4
             bg-gradient-to-br from-indigo-300 via-blue-200 to-purple-300
             bg-[length:300%_300%]
             animate-[gradientMove_10s_ease_infinite]">

    <!-- Card -->
    <div class="w-full max-w-sm animate-card">
        <div class="bg-white/70 backdrop-blur-2xl border border-white/40
                    rounded-3xl shadow-2xl p-8 text-center
                    transition-all duration-300">

            <!-- Logo -->
            <div class="flex justify-center mb-5">
                <img src="<?= base_url('images/gagmo log.jpeg') ?>"
                     alt="Logo"
                     class="w-20 h-20 rounded-2xl object-contain bg-white p-2 shadow-lg animate-logo">
            </div>

            <!-- Title -->
            <h3 class="animate-title text-lg font-semibold tracking-wide
                       bg-gradient-to-r from-blue-600 to-indigo-600
                       bg-clip-text text-transparent mb-4">
                GAGMO Management System
            </h3>

            <!-- Flash message -->
            <?php if(session()->getFlashdata('error')): ?>
                <div class="bg-red-100/80 text-red-700 px-4 py-2 rounded-xl mb-4 text-sm animate-pulse">
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form action="<?= site_url('loginAuth') ?>" method="post" class="space-y-5 text-left">

                <!-- Email -->
                <div class="relative">
                    <input type="email" name="email" required
                        class="peer w-full px-4 py-3 rounded-xl border border-gray-300
                               bg-white/80 text-sm placeholder-transparent
                               focus:outline-none focus:ring-4 focus:ring-blue-300/40">
                    <label
                        class="absolute left-4 top-3 text-gray-500 text-sm
                               transition-all peer-placeholder-shown:top-3.5
                               peer-focus:-top-2 peer-focus:text-xs
                               peer-focus:bg-white peer-focus:px-1">
                        Email Address
                    </label>
                </div>

                <!-- Password -->
                <div class="relative">
                    <input type="password" name="password" required
                        class="peer w-full px-4 py-3 rounded-xl border border-gray-300
                               bg-white/80 text-sm placeholder-transparent
                               focus:outline-none focus:ring-4 focus:ring-blue-300/40">
                    <label
                        class="absolute left-4 top-3 text-gray-500 text-sm
                               transition-all peer-placeholder-shown:top-3.5
                               peer-focus:-top-2 peer-focus:text-xs
                               peer-focus:bg-white peer-focus:px-1">
                        Password
                    </label>
                </div>

                <!-- Button -->
                <button type="submit"
                    class="relative w-full py-3 rounded-xl overflow-hidden
                           text-white font-semibold text-sm
                           bg-gradient-to-r from-blue-500 to-indigo-500
                           hover:from-blue-600 hover:to-indigo-600
                           active:scale-95 transition-all shadow-lg">
                    Sign In
                </button>
            </form>

            <p class="mt-6 text-xs text-gray-500">
                &copy; <?= date('Y') ?> GAGMO Management System. All rights reserved.
            </p>
        </div>
    </div>

</body>
</html>
