<?= $this->extend('layout'); ?>
<?= $this->section('content'); ?>

<?php
$totalIncome = 0;
$totalExpenses = 0;

if (!empty($records)) {
    foreach ($records as $row) {
        if ($row['type'] === 'income') $totalIncome += $row['amount'];
        elseif ($row['type'] === 'expense') $totalExpenses += $row['amount'];
    }
}

$today = date('Y-m-d');
?>

<!-- Dashboard Summary -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
    <div class="bg-green-100 rounded-xl p-4 text-center">
        <p class="text-sm text-gray-600">Total Income</p>
        <p class="text-2xl font-semibold text-green-700"><?= number_format($totalIncome, 2) ?></p>
    </div>
    <div class="bg-red-100 rounded-xl p-4 text-center">
        <p class="text-sm text-gray-600">Total Expenses</p>
        <p class="text-2xl font-semibold text-red-700"><?= number_format($totalExpenses, 2) ?></p>
    </div>
    <div class="bg-blue-100 rounded-xl p-4 text-center">
        <p class="text-sm text-gray-600">Net Amount</p>
        <p class="text-2xl font-semibold text-blue-700"><?= number_format($totalIncome - $totalExpenses, 2) ?></p>
    </div>
</div>

<!-- Header -->
<div class="flex items-center justify-between mb-6 flex-wrap gap-4">
    <div>
        <h1 class="text-2xl font-semibold text-gray-800">Daily Money</h1>
        <p class="text-sm text-gray-500 mt-1">Record income and expenses by account</p>
    </div>
    <div class="flex items-center gap-4">
        <a href="<?= site_url('accounts') ?>" class="text-sm font-medium text-blue-600 hover:underline">
            Manage Accounts
        </a>
        <a href="<?= site_url('assets') ?>" class="text-sm font-medium text-green-600 hover:underline">
            Manage Assets
        </a>
    </div>
</div>


<!-- Back + Add -->
<div class="flex items-center justify-between mb-6 flex-wrap gap-4">
    <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
        ← Back
    </a>

    <button id="openModal" class="bg-blue-600 hover:bg-blue-700 text-white font-medium px-6 py-2 rounded-lg">
        Add New Entry
    </button>
</div>

<!-- Global Search -->
<form method="get" action="<?= site_url('daily-money') ?>" class="mb-6">
    <div class="flex items-center gap-3 flex-wrap">
        <input type="text"
               name="search"
               value="<?= esc($search ?? '') ?>"
               placeholder="Search date, account, description, amount..."
               class="border-gray-300 rounded-lg px-4 py-2 w-80 md:w-96">

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg">
            Search
        </button>

        <?php if (!empty($search)): ?>
            <a href="<?= site_url('daily-money') ?>" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-5 py-2 rounded-lg">
                Reset
            </a>
        <?php endif; ?>
    </div>
</form>

<!-- Modal -->
<div id="entryModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-xl shadow-lg w-full max-w-2xl p-6 relative">

        <h2 class="text-lg font-medium mb-4">New Daily Money Entry</h2>

        <button id="closeModal" class="absolute top-4 right-4 text-gray-500 text-xl">&times;</button>

        <form action="<?= site_url('daily-money/store') ?>" method="post">
            <!-- Date -->
            <div class="mb-4">
                <label class="block text-sm mb-1">Date</label>
                <input type="date" name="entry_date" value="<?= $today ?>" required class="w-full border-gray-300 rounded-lg px-3 py-2">
            </div>

            <!-- Entries Table -->
            <table class="w-full text-sm mb-4" id="rowsTable">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 py-2">Account</th>
                        <th class="px-3 py-2">Type</th>
                        <th class="px-3 py-2">Description</th>
                        <th class="px-3 py-2 text-right">Amount</th>
                        <th class="px-3 py-2 text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="rowTemplate">
                        <td class="px-3 py-2 relative">
                            <input type="text" placeholder="Search account..." class="searchableInput w-full border rounded px-2 py-1">
                            <ul class="optionsList absolute z-10 bg-white border rounded mt-1 max-h-40 overflow-y-auto w-full hidden"></ul>
                            <select name="rows[0][account_id]" class="hidden accountSelect" required>
                                <option value="">Select Account</option>
                                <?php foreach ($accounts as $acc): ?>
                                    <option value="<?= $acc['id'] ?>" data-type="<?= $acc['type'] ?? 'income' ?>">
                                        <?= esc($acc['name']) ?> (<?= ucfirst($acc['type'] ?? 'income') ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                        <td class="px-3 py-2">
                            <input type="text" name="rows[0][type]" class="w-full border rounded px-2 py-1 typeInput" readonly>
                        </td>
                        <td class="px-3 py-2">
                            <input type="text" name="rows[0][description]" class="w-full border rounded px-2 py-1" placeholder="Optional description">
                        </td>
                        <td class="px-3 py-2">
                            <input type="number" step="0.01" name="rows[0][amount]" required class="w-full border rounded px-2 py-1 text-right">
                        </td>
                        <td class="px-3 py-2 text-center">
                            <button type="button" class="removeRow text-red-600 text-lg">&times;</button>
                        </td>
                    </tr>
                </tbody>
            </table>

            <div class="flex justify-between">
                <button type="button" id="addRow" class="bg-gray-200 hover:bg-gray-300 px-4 py-1.5 rounded">
                    Add Row
                </button>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                    Save Entries
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Records Table -->
<div class="bg-white rounded-xl shadow border overflow-x-auto">
    <table class="w-full text-sm min-w-[600px]">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3">Date</th>
                <th class="px-6 py-3">Account</th>
                <th class="px-6 py-3">Type</th>
                <th class="px-6 py-3">Description</th>
                <th class="px-6 py-3 text-right">Amount</th>
                <th class="px-6 py-3 text-center">Action</th>
            </tr>
        </thead>
        <tbody class="divide-y">
            <?php if (!empty($records)): ?>
                <?php foreach ($records as $row): ?>
                    <tr>
                        <td class="px-6 py-3"><?= $row['entry_date'] ?></td>
                        <td class="px-6 py-3"><?= esc($row['account_name']) ?></td>
                        <td class="px-6 py-3"><?= ucfirst($row['type']) ?></td>
                        <td class="px-6 py-3"><?= esc($row['description']) ?></td>
                        <td class="px-6 py-3 text-right"><?= number_format($row['amount'], 2) ?></td>
                        <td class="px-6 py-3 text-center">
                            <a href="<?= site_url('daily-money/delete/'.$row['id']) ?>" onclick="return confirm('Delete this entry?')" class="text-red-600 hover:underline">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center py-6 text-gray-500">No records found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Scripts -->
<script>
// Modal
const modal = document.getElementById('entryModal');
document.getElementById('openModal').onclick = () => modal.classList.remove('hidden');
document.getElementById('closeModal').onclick = () => modal.classList.add('hidden');

// Dynamic Rows
function initRow(row) {
    const input = row.querySelector('.searchableInput');
    const select = row.querySelector('.accountSelect');
    const optionsList = row.querySelector('.optionsList');
    const typeInput = row.querySelector('.typeInput');

    // Build option list for searching
    const optionsData = Array.from(select.options).slice(1).map(opt => ({
        value: opt.value,
        text: opt.text,
        type: opt.dataset.type
    }));

    function showOptions(filter = '') {
        optionsList.innerHTML = '';
        const filtered = optionsData.filter(o => o.text.toLowerCase().includes(filter.toLowerCase()));
        filtered.forEach(o => {
            const li = document.createElement('li');
            li.textContent = o.text;
            li.className = 'px-2 py-1 hover:bg-gray-200 cursor-pointer';
            li.onclick = () => {
                select.value = o.value;
                typeInput.value = o.type;
                input.value = o.text;
                optionsList.classList.add('hidden');
            };
            optionsList.appendChild(li);
        });
        optionsList.classList.toggle('hidden', filtered.length === 0);
    }

    input.addEventListener('input', () => showOptions(input.value));
    input.addEventListener('focus', () => showOptions(input.value));
    input.addEventListener('blur', () => setTimeout(() => optionsList.classList.add('hidden'), 150));

    select.addEventListener('change', () => {
        const opt = select.selectedOptions[0];
        input.value = opt.text;
        typeInput.value = opt.dataset.type;
    });
}

// Initial row
document.querySelectorAll('.rowTemplate').forEach(initRow);

// Add Row
document.getElementById('addRow').onclick = () => {
    const tbody = document.querySelector('#rowsTable tbody');
    const template = document.querySelector('.rowTemplate');
    const clone = template.cloneNode(true);

    // Reset values
    clone.querySelectorAll('input').forEach(inp => inp.value = '');
    clone.querySelector('select').selectedIndex = 0;

    // Update names
    clone.querySelectorAll('input, select').forEach(el => {
        el.name = el.name.replace(/\d+/, tbody.children.length);
    });

    clone.querySelector('.removeRow').onclick = () => clone.remove();
    initRow(clone);

    tbody.appendChild(clone);
};

// Remove Row
document.querySelectorAll('.removeRow').forEach(btn => btn.onclick = e => e.target.closest('tr').remove());
</script>

<?= $this->endSection(); ?>
