<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gradient-to-br from-gray-100 via-slate-100 to-gray-200 min-h-screen">

    <?= view('header'); ?>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-8 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">

        <!-- USERS (ADMIN ONLY) -->
        <?php if (isset($role) && $role === 'manager'): ?>
        <a href="<?= site_url('users') ?>"
           class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md min-h-[170px]
                  transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-blue-100">

            <div class="flex items-center justify-between mb-3">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-blue-100 text-blue-600 text-xl">👥</div>
                <span class="text-xs bg-blue-100 text-blue-600 px-3 py-1 rounded-full font-semibold">Users</span>
            </div>

            <h3 class="text-lg font-semibold text-gray-800 group-hover:text-blue-600">
                Manage Users →
            </h3>

            <p class="text-gray-600 text-sm mt-1 mb-3">
                Create and manage system users.
            </p>

            <div class="flex items-end justify-between mt-auto">
                <span class="text-sm text-gray-500">Total</span>
                <span class="text-2xl font-bold text-blue-600"><?= $totalUsers ?? 0 ?></span>
            </div>
        </a>
        <?php endif; ?>

        <!-- VENDORS (EVERYONE) -->
        <div class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md
                    transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-yellow-100">

            <div class="flex items-center gap-3 mb-4">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-yellow-100 text-yellow-600 text-xl">🚚</div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800 group-hover:text-yellow-600">Vendors</h3>
                    <p class="text-xs text-gray-500">Suppliers & payments</p>
                </div>
            </div>

            <div class="grid grid-cols-2 gap-3 sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-2">
                <a href="<?= site_url('vendors') ?>" class="p-3 rounded-lg bg-yellow-50 hover:bg-yellow-100 text-sm text-center">Suppliers</a>
                <a href="<?= site_url('products') ?>" class="p-3 rounded-lg bg-yellow-50 hover:bg-yellow-100 text-sm text-center">Products</a>
                <a href="<?= site_url('purchases') ?>" class="p-3 rounded-lg bg-yellow-50 hover:bg-yellow-100 text-sm text-center">Purchases</a>
                <a href="<?= site_url('payments') ?>" class="p-3 rounded-lg bg-yellow-50 hover:bg-yellow-100 text-sm text-center">Payments</a>
            </div>
        </div>

        <!-- SALES (EVERYONE) -->
        <div class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md
                    transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-green-100">

            <div class="flex items-center gap-3 mb-4">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-green-100 text-green-600 text-xl">💵</div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800 group-hover:text-green-600">Sales</h3>
                    <p class="text-xs text-gray-500">Track sales & revenue</p>
                </div>
            </div>

            <div class="grid grid-cols-2 gap-3 sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-2">
                <a href="<?= site_url('customer') ?>" class="p-3 rounded-lg bg-green-50 hover:bg-green-100 text-sm text-center">Customers</a>
                <a href="<?= site_url('sales') ?>" class="p-3 rounded-lg bg-green-50 hover:bg-green-100 text-sm text-center">Sales</a>
                <a href="<?= site_url('sales-payments') ?>" class="p-3 rounded-lg bg-green-50 hover:bg-green-100 text-sm text-center">Sales Payments</a>
                <a href="<?= site_url('sales/invoice') ?>" class="p-3 rounded-lg bg-green-50 hover:bg-green-100 text-sm text-center">Invoices</a>
            </div>
        </div>

        <!-- MY DAILY MONEY (ADMIN ONLY) -->
        <?php if (isset($role) && $role === 'manager'): ?>
        <a href="<?= site_url('daily-money') ?>"
           class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md min-h-[170px]
                  transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-purple-100">

            <div class="flex items-center justify-between mb-3">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-purple-100 text-purple-600 text-xl">📅</div>
            </div>

            <h3 class="text-lg font-semibold text-gray-800 group-hover:text-purple-600">
                My Daily Money →
            </h3>

            <p class="text-gray-600 text-sm mt-1">
                Track your personal income & expenses.
            </p>
        </a>
        <?php endif; ?>

        <!-- COMPANY DAILY MONEY (EVERYONE) -->
        <a href="<?= site_url('my-daily-money') ?>"
           class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md min-h-[170px]
                  transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-purple-300">

            <div class="flex items-center justify-between mb-3">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-purple-200 text-purple-700 text-xl">🏢</div>
            </div>

            <h3 class="text-lg font-semibold text-gray-800 group-hover:text-purple-700">
                Company Daily Money →
            </h3>

            <p class="text-gray-600 text-sm mt-1">
                Track overall company income & expenses.
            </p>
        </a>

        <!-- REPORTS (EVERYONE) -->
        <a href="<?= site_url('reports') ?>"
           class="group bg-white/80 backdrop-blur-lg rounded-2xl p-5 shadow-md min-h-[170px]
                  transition-all hover:shadow-xl hover:-translate-y-1 ring-1 ring-indigo-100">

            <div class="flex items-center justify-between mb-3">
                <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-indigo-100 text-indigo-600 text-xl">📊</div>
            </div>

            <h3 class="text-lg font-semibold text-gray-800 group-hover:text-indigo-600">
                Reports →
            </h3>

            <p class="text-gray-600 text-sm mt-1">
                Financial & system reports.
            </p>
        </a>

    </main>

    <footer class="mt-16 text-center text-gray-500 text-sm pb-6">
        © <?= date('Y') ?> GAGMO Management System
    </footer>

</body>
</html>
