<?php if ($pager->hasPages()) : ?>
<nav class="flex justify-center mt-6">
    <ul class="inline-flex items-center space-x-2"> <!-- horizontal row -->
        <!-- Previous Page -->
        <?php if ($pager->hasPreviousPage()) : ?>
            <li>
                <a href="<?= $pager->getPreviousPage() ?>"
                   class="px-3 py-2 rounded bg-gray-200 hover:bg-gray-300 text-gray-700">
                    Prev
                </a>
            </li>
        <?php endif ?>

        <!-- Page Numbers -->
        <?php foreach ($pager->links() as $link) : ?>
            <li>
                <a href="<?= $link['uri'] ?>"
                   class="px-3 py-2 rounded <?= $link['active']
                       ? 'bg-blue-500 text-white'
                       : 'bg-gray-200 hover:bg-gray-300 text-gray-700' ?>">
                    <?= $link['title'] ?>
                </a>
            </li>
        <?php endforeach ?>

        <!-- Next Page -->
        <?php if ($pager->hasNextPage()) : ?>
            <li>
                <a href="<?= $pager->getNextPage() ?>"
                   class="px-3 py-2 rounded bg-gray-200 hover:bg-gray-300 text-gray-700">
                    Next
                </a>
            </li>
        <?php endif ?>
    </ul>
</nav>
<?php endif ?>
