<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Vendor Payments</title>
<script src="https://cdn.tailwindcss.com"></script>
<style>
/* Pagination */
.pagination { display: flex; gap: 0.5rem; justify-content: center; flex-wrap: wrap; }
.pagination li { list-style: none; }
.pagination li a, .pagination li span {
    display: inline-flex; align-items: center; justify-content: center;
    padding: 0.5rem 0.75rem; border: 1px solid #d1d5db; border-radius: 0.375rem;
    color: #374151; text-decoration: none;
}
.pagination li.active span {
    background-color: #2563eb; color: white; border-color: #2563eb;
}
.pagination li a:hover { background-color: #e5e7eb; }
</style>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto mt-8 bg-white p-6 rounded-xl shadow">

    <div class="flex flex-col md:flex-row md:justify-between md:items-center gap-4 mb-6">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">← Back</a>
        <h2 class="text-2xl font-bold text-center md:text-left">Vendor Payments</h2>
        <div class="flex gap-2 items-center relative">
            <button onclick="document.getElementById('downloadMenu').classList.toggle('hidden')"
                    class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">⬇ Download</button>
            <div id="downloadMenu" class="hidden absolute right-0 top-12 bg-white border rounded shadow w-40 z-10">
                <a href="<?= site_url('payments/downloadPdf') ?>" class="block px-4 py-2 hover:bg-gray-100 text-sm">📄 Download PDF</a>
            </div>
        </div>
    </div>

    <?php if ($success): ?>
        <div class="bg-green-100 text-green-700 p-3 rounded mb-4"><?= esc($success) ?></div>
    <?php endif; ?>

    <form action="<?= site_url('payments/store') ?>" method="POST" class="grid grid-cols-1 md:grid-cols-5 gap-3 mb-6">
        <select name="vendor_id" required class="border p-2 rounded">
            <option value="">Select Vendor</option>
            <?php foreach ($vendors as $v): ?>
                <option value="<?= $v['id'] ?>"><?= esc($v['name']) ?> | Balance: <?= number_format($v['balance'], 2) ?></option>
            <?php endforeach; ?>
        </select>
        <input type="number" step="0.01" name="amount" placeholder="Amount Paid" required class="border p-2 rounded">
        <input type="date" name="payment_date" class="border p-2 rounded">
        <input type="text" name="note" placeholder="Note (optional)" class="border p-2 rounded">
        <button class="bg-blue-600 text-white rounded px-4 hover:bg-blue-700">Pay</button>
    </form>

    <!-- Unified Search -->
    <form method="GET" action="<?= site_url('payments') ?>" class="mb-4 flex items-center gap-2">
        <input type="text" name="search" placeholder="Search by vendor, amount, date, note..." 
               value="<?= esc($search ?? '') ?>" class="border rounded px-3 py-2 w-64 text-sm">
        <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">Search</button>
    </form>

    <div class="overflow-x-auto">
        <table class="w-full border text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Vendor</th>
                    <th class="border p-2">Amount</th>
                    <th class="border p-2">Date</th>
                    <th class="border p-2">Note</th>
                    <th class="border p-2 text-center">View</th>
                    <th class="border p-2 text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($payments)): ?>
                    <?php foreach ($payments as $i => $p): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="border p-2 font-medium"><?= esc($p['vendor_name']) ?></td>
                            <td class="border p-2"><?= number_format($p['amount'], 2) ?></td>
                            <td class="border p-2"><?= esc($p['payment_date']) ?></td>
                            <td class="border p-2"><?= esc($p['note']) ?></td>
                            <td class="border p-2 text-center">
                                <a href="<?= site_url('payments/vendorItems/'.$p['vendor_id']) ?>" 
                                   class="bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700">
                                   View
                                </a>
                            </td>
                            <td class="border p-2 text-center">
                                <a href="<?= site_url('payments/delete/'.$p['id']) ?>" onclick="return confirm('Delete payment?')" class="text-red-600 font-bold">✕</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center p-4 text-gray-500">No payments found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4 flex justify-center items-center gap-3">
        <?php if ($pager->getCurrentPage() > 1): ?>
            <a href="<?= $pager->getPageURI($pager->getCurrentPage() - 1) ?>" class="px-3 py-1 border rounded hover:bg-gray-200">Previous</a>
        <?php endif; ?>

        <form method="get" class="flex items-center gap-2">
            <?php if($search): ?>
                <input type="hidden" name="search" value="<?= esc($search) ?>">
            <?php endif; ?>
            <label class="text-gray-700">Page</label>
            <select name="page" onchange="this.form.submit()" class="px-2 py-1 border rounded">
                <?php for($i = 1; $i <= $pager->getPageCount(); $i++): ?>
                    <option value="<?= $i ?>" <?= $i == $pager->getCurrentPage() ? 'selected' : '' ?>><?= $i ?></option>
                <?php endfor; ?>
            </select>
            <span>of <?= $pager->getPageCount() ?></span>
        </form>

        <?php if ($pager->getCurrentPage() < $pager->getPageCount()): ?>
            <a href="<?= $pager->getPageURI($pager->getCurrentPage() + 1) ?>" class="px-3 py-1 border rounded hover:bg-gray-200">Next</a>
        <?php endif; ?>
    </div>

</div>
</body>
</html>
