<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Product</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-xl mx-auto mt-10 bg-white p-6 rounded-xl shadow">

    <h2 class="text-2xl font-bold mb-4 text-center">Edit Product</h2>

    <?php if (!empty($errors)): ?>
        <div class="mb-4 bg-red-100 text-red-700 px-4 py-3 rounded-lg">
            <ul class="list-disc pl-5">
                <?php foreach ($errors as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?= site_url('products/update/' . $product['id']) ?>" method="POST" class="space-y-4">

        <!-- PRODUCT NAME -->
        <div>
            <label class="block font-medium mb-1">Name</label>
            <input type="text"
                   name="name"
                   value="<?= old('name', $product['name']) ?>"
                   class="w-full border px-3 py-2 rounded-lg"
                   required>
        </div>

        <!-- PRODUCT PRICE -->
        <div>
            <label class="block font-medium mb-1">Price</label>
            <input type="number"
                   step="0.01"
                   name="price"
                   value="<?= old('price', $product['price']) ?>"
                   class="w-full border px-3 py-2 rounded-lg"
                   required>
        </div>

        <!-- ACTION BUTTONS -->
        <div class="flex justify-between pt-2">
            <a href="<?= site_url('products') ?>"
               class="bg-gray-400 hover:bg-gray-500 text-white px-4 py-2 rounded-lg">
                Cancel
            </a>

            <button type="submit"
                    class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">
                Update Product
            </button>
        </div>

    </form>
</div>

</body>
</html>
