<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Products</title>
<script src="https://cdn.tailwindcss.com"></script>

<style>
/* Pagination Styling */
.pagination {
    display: flex;
    gap: 0.25rem;
    justify-content: center;
    flex-wrap: wrap;
}
.pagination li { list-style: none; }
.pagination li a,
.pagination li span {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.25rem 0.5rem;
    border: 1px solid #d1d5db;
    border-radius: 0.25rem;
    color: #374151;
    text-decoration: none;
    font-size: 0.75rem;
}
.pagination li.active span {
    background-color: #2563eb;
    color: white;
    border-color: #2563eb;
}
.pagination li a:hover { background-color: #e5e7eb; }
</style>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 mt-6">

    <!-- Page Header & Search -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-4">
        <div class="flex flex-col sm:flex-row sm:items-center gap-2 w-full md:w-auto flex-wrap">
            <a href="<?= site_url('dashboard') ?>" 
               class="inline-flex items-center gap-2 px-2 py-1 rounded bg-gray-600 text-white text-xs sm:text-sm">
               ← Dashboard
            </a>

            <form method="get" class="flex gap-1 w-full sm:w-auto flex-wrap">
                <input type="text" name="search" value="<?= esc($search) ?>"
                       placeholder="Search products..."
                       class="flex-1 min-w-[100px] border px-2 py-1 rounded text-xs sm:text-sm">
                <button class="bg-gray-600 text-white px-2 py-1 rounded text-xs sm:text-sm w-full sm:w-auto">
                    Search
                </button>
            </form>
        </div>

        <button onclick="toggleModal('addProductModal')"
                class="bg-green-500 hover:bg-green-600 text-white px-3 py-1.5 rounded shadow text-xs sm:text-sm w-full sm:w-auto">
            + Add Product
        </button>
    </div>

    <!-- Products Table -->
    <div class="bg-white shadow rounded-xl overflow-x-auto text-xs sm:text-sm">
        <table class="min-w-full divide-y table-auto">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-2 py-1 text-left">#</th>
                    <th class="px-2 py-1 text-left">Name</th>
                    <th class="px-2 py-1 text-left">Price</th>
                    <th class="px-2 py-1 text-left">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y">
                <?php foreach($products as $i => $product): ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-2 py-1"><?= $i + 1 ?></td>
                    <td class="px-2 py-1"><?= esc($product['name']) ?></td>
                    <td class="px-2 py-1">Tsh. <?= number_format($product['price'], 2) ?></td>
                    <td class="px-2 py-1 flex flex-wrap gap-1">
                        <button onclick="viewProduct(<?= $product['id'] ?>)" class="text-blue-600 text-xs">View</button>
                        <a href="<?= site_url('products/edit/'.$product['id']) ?>" class="text-green-600 text-xs">Edit</a>
                        <a href="<?= site_url('products/delete/'.$product['id']) ?>"
                           onclick="return confirm('Are you sure?')" class="text-red-600 text-xs">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <ul class="pagination mt-2">
        <?php if ($pager->getCurrentPage() > 1): ?>
            <li><a href="<?= $pager->getPageURI($pager->getCurrentPage() - 1) ?>">Previous</a></li>
        <?php endif; ?>
        <?php for($i = 1; $i <= $pager->getPageCount(); $i++): ?>
            <li class="<?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                <span><?= $i ?></span>
            </li>
        <?php endfor; ?>
        <?php if ($pager->getCurrentPage() < $pager->getPageCount()): ?>
            <li><a href="<?= $pager->getPageURI($pager->getCurrentPage() + 1) ?>">Next</a></li>
        <?php endif; ?>
    </ul>

</div>

<!-- ADD PRODUCT MODAL -->
<div id="addProductModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-2">
    <div class="bg-white rounded-lg p-4 w-full max-w-2xl shadow-lg overflow-y-auto max-h-full">
        <h2 class="text-lg font-bold mb-3 text-center">Add Products</h2>

        <form action="<?= site_url('products/store') ?>" method="POST" class="space-y-3">

            <div class="overflow-x-auto">
                <table class="min-w-full border rounded text-xs sm:text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-2 py-1">Name</th>
                            <th class="px-2 py-1">Price</th>
                            <th class="px-2 py-1">Action</th>
                        </tr>
                    </thead>
                    <tbody id="productRows">
                        <tr>
                            <td class="px-1 py-1">
                                <input type="text" name="name[]" required class="w-full border px-2 py-1 rounded text-xs sm:text-sm">
                            </td>
                            <td class="px-1 py-1">
                                <input type="number" step="0.01" name="price[]" required class="w-full border px-2 py-1 rounded text-xs sm:text-sm">
                            </td>
                            <td class="px-1 py-1 text-center">
                                <button type="button" onclick="removeRow(this)" class="text-red-600 text-base">✕</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="flex flex-col sm:flex-row justify-between gap-2">
                <button type="button" onclick="addRow()" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1.5 rounded w-full sm:w-auto text-xs sm:text-sm">
                    + Add Row
                </button>

                <div class="flex gap-1 w-full sm:w-auto flex-wrap">
                    <button type="button" onclick="toggleModal('addProductModal')" class="bg-gray-400 hover:bg-gray-500 text-white px-3 py-1.5 rounded flex-1 text-xs sm:text-sm">
                        Cancel
                    </button>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white px-3 py-1.5 rounded flex-1 text-xs sm:text-sm">
                        Save Products
                    </button>
                </div>
            </div>

        </form>
    </div>
</div>

<script>
function toggleModal(id) { document.getElementById(id).classList.toggle('hidden'); }
function addRow() {
    document.getElementById('productRows').insertAdjacentHTML('beforeend', `
        <tr>
            <td class="px-1 py-1"><input type="text" name="name[]" required class="w-full border px-2 py-1 rounded text-xs sm:text-sm"></td>
            <td class="px-1 py-1"><input type="number" step="0.01" name="price[]" required class="w-full border px-2 py-1 rounded text-xs sm:text-sm"></td>
            <td class="px-1 py-1 text-center"><button type="button" onclick="removeRow(this)" class="text-red-600 text-base">✕</button></td>
        </tr>
    `);
}
function removeRow(btn) {
    const rows = document.querySelectorAll('#productRows tr');
    if (rows.length > 1) btn.closest('tr').remove();
}
function viewProduct(id) {
    fetch('<?= site_url('products/view') ?>/' + id)
        .then(res => res.json())
        .then(data => {
            alert(`Product: ${data.name}\nPrice: ${data.price}`);
        });
}
</script>

</body>
</html>
