<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Purchase</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-4xl mx-auto mt-8 bg-white p-6 rounded-xl shadow">

    <div class="flex items-center justify-between mb-6">
    <h2 class="text-2xl font-bold">Edit Purchase</h2>
    <a href="<?= site_url('/purchases') ?>" 
       class="text-white bg-gray-600 hover:bg-gray-700 px-4 py-2 rounded">
        ← Back
    </a>
</div>


    <form action="<?= site_url('purchases/update/'.$purchase['id']) ?>" method="POST" class="space-y-4">

        <!-- Date -->
        <div>
            <label class="block font-semibold mb-1">Purchase Date</label>
            <input type="date" name="purchase_date" value="<?= esc($purchase['purchase_date'] ?? date('Y-m-d')) ?>"
                   class="w-full border rounded px-3 py-2">
        </div>

        <!-- Vendor -->
        <div>
            <label class="block font-semibold mb-1">Vendor</label>
            <select name="vendor" class="w-full border rounded px-3 py-2">
                <option value="">-- Select Vendor --</option>
                <?php foreach($vendors as $v): ?>
                    <option value="<?= esc($v['name']) ?>" <?= $purchase['vendor_name'] == $v['name'] ? 'selected' : '' ?>>
                        <?= esc($v['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Product -->
        <div>
            <label class="block font-semibold mb-1">Product</label>
            <select name="product" class="w-full border rounded px-3 py-2">
                <option value="">-- Select Product --</option>
                <?php foreach($products as $p): ?>
                    <option value="<?= esc($p['name']) ?>" <?= $purchase['product_name'] == $p['name'] ? 'selected' : '' ?>>
                        <?= esc($p['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Price -->
        <div>
            <label class="block font-semibold mb-1">Price</label>
            <input type="number" step="0.01" name="price" value="<?= esc($purchase['price']) ?>"
                   class="w-full border rounded px-3 py-2">
        </div>

        <!-- Quantity -->
        <div>
            <label class="block font-semibold mb-1">Quantity</label>
            <input type="number" name="quantity" value="<?= esc($purchase['quantity']) ?>"
                   class="w-full border rounded px-3 py-2">
        </div>

        <div class="flex justify-end gap-3 mt-6">
            <a href="<?= site_url('/purchases') ?>" class="px-4 py-2 rounded bg-gray-300 hover:bg-gray-400">Cancel</a>
            <button type="submit" class="px-6 py-2 rounded bg-green-600 text-white hover:bg-green-700">
                Save
            </button>
        </div>
    </form>

</div>

</body>
</html>
