<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Purchases</title>
<script src="https://cdn.tailwindcss.com"></script>
<style>
/* Pagination Styles */
.pagination {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
    flex-wrap: wrap;
}
.pagination li {
    list-style: none;
}
.pagination li a,
.pagination li span {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.5rem 0.75rem;
    border: 1px solid #d1d5db; /* gray-300 */
    border-radius: 0.375rem;  /* rounded-md */
    color: #374151;           /* gray-700 */
    text-decoration: none;
}
.pagination li.active span {
    background-color: #2563eb; /* blue-600 */
    color: white;
    border-color: #2563eb;
}
.pagination li a:hover {
    background-color: #e5e7eb; /* gray-200 */
}
</style>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto mt-8 bg-white p-6 rounded-xl shadow">

    <!-- Back Button -->
    <div class="mb-4">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded">
            ← Back
        </a>
    </div>

    <h2 class="text-2xl font-bold text-center mb-6 text-gray-800">Record Purchases</h2>

    <?php if ($success): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 p-3 mb-4 rounded">
        <?= esc($success) ?>
    </div>
    <?php endif; ?>

    <!-- Purchase Form -->
    <form action="<?= site_url('purchases/store') ?>" method="POST">

        <!-- Purchase Date -->
        <div class="mb-4 flex items-center gap-4">
            <label class="text-gray-700 font-semibold">Purchase Date:</label>
            <input type="date" name="purchase_date_global" class="border p-2 rounded" value="<?= date('Y-m-d') ?>">
        </div>

        <!-- Table Header -->
        <div class="grid grid-cols-12 gap-2 font-semibold border-b pb-2 mb-2 bg-gray-50 rounded-t">
            <div class="col-span-2">Vendor</div>
            <div class="col-span-2">Product</div>
            <div class="col-span-2">Price</div>
            <div class="col-span-2">Qty</div>
            <div class="col-span-2">Total</div>
            <div class="col-span-2">X</div>
        </div>

        <!-- Rows -->
        <div id="rows">
            <div class="grid grid-cols-12 gap-2 row mb-2 items-center">
                <!-- Vendor -->
                <select name="vendor[]" class="col-span-2 border p-2 rounded vendor-select" onchange="toggleNew(this)">
                    <option value="">Select Vendor</option>
                    <?php foreach($vendors as $v): ?>
                        <option value="<?= esc($v['name']) ?>"><?= esc($v['name']) ?></option>
                    <?php endforeach; ?>
                    <option value="_new">+ Add New</option>
                </select>
                <input type="text" name="vendor_new[]" placeholder="New Vendor" class="col-span-2 border p-2 rounded hidden">

                <!-- Product -->
                <select name="product[]" class="col-span-2 border p-2 rounded product-select" onchange="toggleNew(this)">
                    <option value="">Select Product</option>
                    <?php foreach($products as $p): ?>
                        <option value="<?= esc($p['name']) ?>"><?= esc($p['name']) ?></option>
                    <?php endforeach; ?>
                    <option value="_new">+ Add New</option>
                </select>
                <input type="text" name="product_new[]" placeholder="New Product" class="col-span-2 border p-2 rounded hidden">

                <!-- Price & Qty -->
                <input type="number" step="0.01" name="price[]" oninput="calc(this); calcPageTotal();" placeholder="Price" class="col-span-2 border p-2 rounded">
                <input type="number" name="quantity[]" oninput="calc(this); calcPageTotal();" placeholder="Qty" class="col-span-2 border p-2 rounded">

                <!-- Total -->
                <input readonly class="col-span-2 border p-2 rounded bg-gray-100 total">

                <!-- Delete Row -->
                <button type="button" onclick="deleteRow(this); calcPageTotal();" class="col-span-2 text-white bg-red-500 rounded px-2 py-1 hover:bg-red-600">X</button>
            </div>
        </div>

        <div class="flex justify-between mt-4">
            <button type="button" onclick="addRow()" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">+ Add Row</button>
            <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded hover:bg-green-700">Save</button>
        </div>

    </form>

    <!-- Search -->
    <div class="flex justify-end mt-6 mb-3">
        <form method="get" class="flex gap-2">
            <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Search" class="border px-3 py-2 rounded w-48">
            <button class="bg-gray-700 text-white px-4 rounded hover:bg-gray-800">Search</button>
        </form>
    </div>

    <!-- Purchases Table -->
    <div class="overflow-x-auto mt-4">
        <table class="min-w-full border shadow-sm rounded">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Date</th>
                    <th class="border p-2">Vendor</th>
                    <th class="border p-2">Product</th>
                    <th class="border p-2">Price</th>
                    <th class="border p-2">Qty</th>
                    <th class="border p-2">Total</th>
                    <th class="border p-2">Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php $pageTotal = 0; ?>
            <?php foreach ($purchases as $p): ?>
                <?php $lineTotal = $p['price'] * $p['quantity']; ?>
                <?php $pageTotal += $lineTotal; ?>
                <tr class="hover:bg-gray-50">
                    <td class="border p-2"><?= esc($p['purchase_date'] ?? date('Y-m-d')) ?></td>
                    <td class="border p-2"><?= esc($p['vendor_name']) ?></td>
                    <td class="border p-2"><?= esc($p['product_name']) ?></td>
                    <td class="border p-2"><?= number_format($p['price'],2) ?></td>
                    <td class="border p-2"><?= $p['quantity'] ?></td>
                    <td class="border p-2 font-semibold"><?= number_format($lineTotal,2) ?></td>
                    <td class="border p-2 space-x-3">
                        <a href="<?= site_url('purchases/edit/'.$p['id']) ?>" class="text-blue-600 hover:underline">Edit</a>
                        <a href="<?= site_url('purchases/delete/'.$p['id']) ?>" onclick="return confirm('Delete purchase?')" class="text-red-600 hover:underline">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-100 font-bold">
                    <td colspan="5" class="border p-2 text-right">Page Total:</td>
                    <td class="border p-2 text-green-700" id="pageTotal"><?= number_format($pageTotal,2) ?></td>
                    <td class="border p-2"></td>
                </tr>
            </tfoot>
        </table>
    </div>

  <!-- Pagination -->
<div class="mt-4 flex justify-center items-center gap-3">

    <!-- Previous Button -->
    <?php if ($pager->getCurrentPage() > 1): ?>
        <a href="<?= $pager->getPageURI($pager->getCurrentPage() - 1) ?>" class="px-3 py-1 border rounded hover:bg-gray-200">Previous</a>
    <?php endif; ?>

    <!-- Page Selector Dropdown -->
    <form method="get" class="flex items-center gap-2">
        <label class="text-gray-700">Page</label>
        <select name="page" onchange="this.form.submit()" class="px-2 py-1 border rounded">
            <?php for($i = 1; $i <= $pager->getPageCount(); $i++): ?>
                <option value="<?= $i ?>" <?= $i == $pager->getCurrentPage() ? 'selected' : '' ?>>
                    <?= $i ?>
                </option>
            <?php endfor; ?>
        </select>
        <span>of <?= $pager->getPageCount() ?></span>
    </form>

    <!-- Next Button -->
    <?php if ($pager->getCurrentPage() < $pager->getPageCount()): ?>
        <a href="<?= $pager->getPageURI($pager->getCurrentPage() + 1) ?>" class="px-3 py-1 border rounded hover:bg-gray-200">Next</a>
    <?php endif; ?>

</div>



</div>

<script>
function addRow() {
    const row = document.querySelector('.row').cloneNode(true);
    row.querySelectorAll('input').forEach(i => i.value = '');
    row.querySelectorAll('select').forEach(s => s.selectedIndex = 0);
    row.querySelectorAll('.hidden').forEach(h => h.classList.add('hidden'));
    document.getElementById('rows').appendChild(row);
}

function calc(el) {
    const row = el.closest('.row');
    const price = parseFloat(row.querySelector('[name="price[]"]').value) || 0;
    const qty = parseInt(row.querySelector('[name="quantity[]"]').value) || 0;
    row.querySelector('.total').value = (price * qty).toFixed(2);
}

function calcPageTotal() {
    let total = 0;
    document.querySelectorAll('.total').forEach(input => {
        total += parseFloat(input.value) || 0;
    });
    document.getElementById('pageTotal').textContent = total.toFixed(2);
}

function toggleNew(select) {
    const input = select.nextElementSibling;
    if(select.value === '_new') {
        input.classList.remove('hidden');
    } else {
        input.classList.add('hidden');
        input.value = '';
    }
}

function deleteRow(btn) {
    const row = btn.closest('.row');
    row.remove();
    calcPageTotal();
}
</script>

</body>
</html>
