<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Reports Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.tailwindcss.com"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
    * { font-family: 'Inter', sans-serif; }
</style>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-10">
    <a href="<?= site_url('dashboard') ?>" class="inline-block bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 mb-4">← Back</a>

    <h1 class="text-3xl font-bold text-gray-800 mb-2">Reports Dashboard</h1>
    <p class="text-gray-600 mb-6">View all financial reports: sales, purchases, profit & loss summaries.</p>
</section>

<main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-6 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">

    <!-- Sales Report Card -->
    <!-- Sales Report Card -->
<a href="<?= site_url('reports/sales') ?>" class="group bg-white rounded-2xl shadow-md p-6 hover:-translate-y-1 transition-all ring-1 ring-indigo-100">
    <div class="flex items-center justify-between mb-4">
        <div class="w-12 h-12 rounded-xl bg-indigo-500 flex items-center justify-center text-white">
            <i class="fas fa-chart-line"></i>
        </div>
        <span class="text-xs font-semibold px-2 py-1 rounded-full bg-indigo-100 text-indigo-700">Sales</span>
    </div>
    <h3 class="text-lg font-bold group-hover:text-indigo-600">Sales Report →</h3>
    <p class="text-sm text-gray-600 mt-1">View sales performance daily, monthly, and yearly.</p>

    <!-- Today Stats -->
    <div class="mt-4 border-t pt-2 text-sm text-gray-700 space-y-1">
        <div class="flex justify-between">
            <span>Sales</span>
            <span class="font-semibold text-green-600">
                Tsh <?= isset($todaySalesTotal) ? number_format($todaySalesTotal, 2) : '0.00' ?>
            </span>
        </div>
        <div class="flex justify-between">
            <span>Payments</span>
            <span class="font-semibold text-blue-600">
                Tsh <?= isset($todayPayments) ? number_format($todayPayments, 2) : '0.00' ?>
            </span>
        </div>
    </div>
</a>


    <!-- Purchases Report Card -->
    <a href="<?= site_url('reports/purchases') ?>" class="group bg-white rounded-2xl shadow-md p-6 hover:-translate-y-1 transition-all ring-1 ring-emerald-100">
        <div class="flex items-center justify-between mb-4">
            <div class="w-12 h-12 rounded-xl bg-emerald-500 flex items-center justify-center text-white">
                <i class="fas fa-file-invoice-dollar"></i>
            </div>
            <span class="text-xs font-semibold px-2 py-1 rounded-full bg-emerald-100 text-emerald-700">Purchases</span>
        </div>
        <h3 class="text-lg font-bold group-hover:text-emerald-600">Purchase Report →</h3>
        <p class="text-sm text-gray-600 mt-1">Track supplier purchases, costs, and history.</p>
    </a>

    <!-- Profit & Loss Report Card -->
    <a href="<?= site_url('reports/profit') ?>" class="group bg-white rounded-2xl shadow-md p-6 hover:-translate-y-1 transition-all ring-1 ring-rose-100">
        <div class="flex items-center justify-between mb-4">
            <div class="w-12 h-12 rounded-xl bg-rose-500 flex items-center justify-center text-white">
                <i class="fas fa-wallet"></i>
            </div>
            <span class="text-xs font-semibold px-2 py-1 rounded-full bg-rose-100 text-rose-700">Profit & Loss</span>
        </div>
        <h3 class="text-lg font-bold group-hover:text-rose-600">Profit & Loss →</h3>
        <p class="text-sm text-gray-600 mt-1">View daily, weekly, monthly, and yearly profit & loss.</p>

        <!-- Today Stats -->
        <div class="mt-4 border-t pt-2 text-sm text-gray-700 space-y-1">
            <div class="flex justify-between">
                <span>Income</span>
                <span class="font-semibold text-green-600">Tsh <?= isset($todayIncome) ? number_format($todayIncome, 2) : '0.00' ?></span>
            </div>
            <div class="flex justify-between">
                <span>Expense</span>
                <span class="font-semibold text-red-600">Tsh <?= isset($todayExpense) ? number_format($todayExpense, 2) : '0.00' ?></span>
            </div>
            <div class="flex justify-between font-bold pt-1 border-t">
                <span>Balance</span>
                <span class="<?= (isset($todayIncome, $todayExpense) && ($todayIncome - $todayExpense) >= 0) ? 'text-blue-600' : 'text-red-600' ?>">
                    Tsh <?= isset($todayIncome, $todayExpense) ? number_format($todayIncome - $todayExpense, 2) : '0.00' ?>
                </span>
            </div>
        </div>
    </a>

</main>

<footer class="mt-16 text-center text-gray-500 text-sm pb-6">
    © <?= date('Y') ?> GGM Management System
</footer>

</body>
</html>
