<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Profit & Loss Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-7xl mx-auto px-6 mt-8">
    <a href="<?= site_url('reports') ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">← Back</a>

    <h1 class="text-3xl font-bold mb-6">Profit & Loss Report</h1>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <?php 
        $cards = [
            'Daily' => [$dailyIncome, $dailyExpense],
            'Weekly' => [$weeklyIncome, $weeklyExpense],
            'Monthly' => [$monthlyIncome, $monthlyExpense],
            'Yearly' => [$yearlyIncome, $yearlyExpense],
        ]; 
        ?>
        <?php foreach($cards as $label => [$income, $expense]): ?>
            <div class="bg-white rounded-xl shadow p-5">
                <p class="text-sm text-gray-500"><?= $label ?></p>
                <p class="text-green-600 font-semibold mt-2">Income: Tsh <?= number_format($income, 2) ?></p>
                <p class="text-red-600 font-semibold">Expense: Tsh <?= number_format($expense, 2) ?></p>
                <div class="mt-3 border-t pt-2 font-bold <?= ($income - $expense) >=0 ? 'text-blue-600' : 'text-red-600' ?>">
                    Balance: Tsh <?= number_format($income - $expense, 2) ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Transactions Table -->
    <div class="bg-white rounded-xl shadow overflow-hidden">
        <div class="px-6 py-4 border-b font-semibold text-gray-700">All Transactions</div>
        <table class="w-full text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left">Date</th>
                    <th class="px-4 py-2 text-left">Type</th>
                    <th class="px-4 py-2 text-left">Description</th>
                    <th class="px-4 py-2 text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($records as $row): ?>
                    <tr class="border-t">
                        <td class="px-4 py-2"><?= date('Y-m-d', strtotime($row['created_at'])) ?></td>
                        <td class="px-4 py-2 capitalize"><?= esc($row['type']) ?></td>
                        <td class="px-4 py-2"><?= esc($row['description']) ?></td>
                        <td class="px-4 py-2 text-right <?= $row['type'] === 'income' ? 'text-green-600' : 'text-red-600' ?>">
                            Tsh <?= number_format($row['amount'], 2) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>
