<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales & Payments Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-7xl mx-auto px-6 mt-8">

   <a href="<?= site_url('reports') ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">← Back</a>


    <h1 class="text-3xl font-bold mt-4 mb-8">Sales & Payments Overview</h1>

    <!-- SALES SECTION -->
    <h2 class="text-xl font-semibold mb-4 text-gray-700">Sales (Recorded)</h2>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">

        <?php
        $salesCards = [
            'Daily Sales'   => $dailySales,
            'Weekly Sales'  => $weeklySales,
            'Monthly Sales' => $monthlySales,
            'Yearly Sales'  => $yearlySales,
        ];
        ?>

        <?php foreach ($salesCards as $label => $value): ?>
            <div class="bg-white rounded-xl shadow p-6">
                <p class="text-sm text-gray-500 uppercase"><?= $label ?></p>
                <p class="text-2xl font-bold text-green-600 mt-2">
                    Tsh <?= number_format((float)$value, 2) ?>
                </p>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- PAYMENTS SECTION -->
    <h2 class="text-xl font-semibold mb-4 text-gray-700">Payments Received</h2>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">

        <?php
        $paymentCards = [
            'Daily Payments'   => $dailyPayments,
            'Weekly Payments'  => $weeklyPayments,
            'Monthly Payments' => $monthlyPayments,
            'Yearly Payments'  => $yearlyPayments,
        ];
        ?>

        <?php foreach ($paymentCards as $label => $value): ?>
            <div class="bg-white rounded-xl shadow p-6">
                <p class="text-sm text-gray-500 uppercase"><?= $label ?></p>
                <p class="text-2xl font-bold text-blue-600 mt-2">
                    Tsh <?= number_format((float)$value, 2) ?>
                </p>
            </div>
        <?php endforeach; ?>
    </div>

</div>

</body>
</html>
