<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customers</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-4xl mx-auto px-4 py-6">

    <!-- Page Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded">
            ← Back
        </a>

        <div class="flex flex-col sm:flex-row items-start sm:items-center gap-2 w-full sm:w-auto">

            <!-- Search -->
            <form method="get" class="flex gap-2 w-full sm:w-auto">
                <input type="text"
                       name="search"
                       value="<?= esc($search ?? '') ?>"
                       placeholder="Search customers..."
                       class="flex-1 border border-gray-300 px-3 py-2 rounded-lg focus:ring-2 focus:ring-blue-400 focus:outline-none">
                <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    Search
                </button>
            </form>

            <!-- Add Customer -->
            <button onclick="toggleModal('addCustomerModal')"
                    class="flex items-center gap-1 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg mt-2 sm:mt-0">
                <span class="text-lg">+</span> Add Customer
            </button>
        </div>
    </div>

    <!-- Customers Table -->
    <div class="bg-white shadow rounded-lg overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200 table-auto">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 py-2 text-left text-sm font-semibold text-gray-600">#</th>
                    <th class="px-3 py-2 text-left text-sm font-semibold text-gray-600">Name</th>
                    <th class="px-3 py-2 text-left text-sm font-semibold text-gray-600">Contact</th>
                    <th class="px-3 py-2 text-left text-sm font-semibold text-gray-600">Address</th>
                    <th class="px-3 py-2 text-left text-sm font-semibold text-gray-600">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php foreach ($customers as $i => $customer): ?>
                    <tr class="hover:bg-gray-50 transition">
                        <td class="px-3 py-2"><?= $i + 1 ?></td>
                        <td class="px-3 py-2 font-medium"><?= esc($customer['name']) ?></td>
                        <td class="px-3 py-2 text-gray-600"><?= esc($customer['phone'] ?? '-') ?></td>
                        <td class="px-3 py-2 text-gray-600"><?= esc($customer['address'] ?? '-') ?></td>
                        <td class="px-3 py-2">
                            <div class="flex flex-wrap gap-2">
                                <button
                                    onclick="editCustomer(<?= $customer['id'] ?>)"
                                    class="px-3 py-1 text-sm text-blue-600 bg-blue-50 rounded-lg border border-blue-200 hover:bg-blue-100 transition">
                                    ✏ Edit
                                </button>
                                <a
                                    href="<?= site_url('customers/delete/'.$customer['id']) ?>"
                                    onclick="return confirm('Are you sure?')"
                                    class="px-3 py-1 text-sm text-red-600 bg-red-50 rounded-lg border border-red-200 hover:bg-red-100 transition">
                                    🗑 Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- ADD CUSTOMER MODAL -->
<div id="addCustomerModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-lg">
        <h2 class="text-xl font-bold mb-4 text-center">Add Customer</h2>
        <form method="POST" action="<?= site_url('customers/store') ?>" class="space-y-3">
            <input type="text" name="name" placeholder="Name" required class="w-full border px-3 py-2 rounded-lg">
            <input type="text" name="phone" placeholder="Contact" class="w-full border px-3 py-2 rounded-lg">
            <input type="text" name="address" placeholder="Address" class="w-full border px-3 py-2 rounded-lg">
            <div class="flex justify-end gap-2">
                <button type="button" onclick="toggleModal('addCustomerModal')" class="bg-gray-400 hover:bg-gray-500 text-white px-4 py-2 rounded-lg">Cancel</button>
                <button class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">Save</button>
            </div>
        </form>
    </div>
</div>

<!-- EDIT CUSTOMER MODAL -->
<div id="editCustomerModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-lg">
        <h2 class="text-xl font-bold mb-4 text-center">Edit Customer</h2>
        <form id="editCustomerForm" method="POST" action="<?= site_url('customers/update') ?>" class="space-y-3">
            <input type="hidden" name="id" id="editCustomerId">
            <input type="text" name="name" id="editCustomerName" placeholder="Name" class="w-full border px-3 py-2 rounded-lg" required>
            <input type="text" name="phone" id="editCustomerPhone" placeholder="Phone" class="w-full border px-3 py-2 rounded-lg">
            <input type="text" name="address" id="editCustomerAddress" placeholder="Address" class="w-full border px-3 py-2 rounded-lg">
            <div class="flex justify-end gap-2">
                <button type="button" onclick="toggleModal('editCustomerModal')" class="bg-gray-400 hover:bg-gray-500 text-white px-4 py-2 rounded-lg">Cancel</button>
                <button class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg">Update</button>
            </div>
        </form>
    </div>
</div>

<script>
function toggleModal(id) {
    document.getElementById(id).classList.toggle('hidden');
}

function editCustomer(id) {
    fetch('<?= site_url('customers/view') ?>/' + id)
        .then(res => res.json())
        .then(data => {
            document.getElementById('editCustomerId').value = data.id;
            document.getElementById('editCustomerName').value = data.name;
            document.getElementById('editCustomerPhone').value = data.phone || '';
            document.getElementById('editCustomerAddress').value = data.address || '';
            toggleModal('editCustomerModal');
        });
}
</script>

</body>
</html>
