<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Sale</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-7xl mx-auto px-6 mt-6">

    <a href="<?= site_url('sales') ?>" class="bg-gray-600 text-white px-4 py-2 rounded mb-4 inline-block">
        ← Back to Sales
    </a>

    <div class="bg-white rounded-xl shadow p-6">

        <h2 class="text-2xl font-bold mb-6 text-center">Edit Sale</h2>

        <form action="<?= site_url('sales/update/'.$sale['id']) ?>" method="POST">

            <!-- CUSTOMER -->
            <div class="mb-4">
                <label class="block mb-1 font-medium">Customer</label>
                <select name="customer_id" class="customerSelect w-full border px-3 py-2 rounded" required>
                    <option value="">Select Customer</option>
                    <?php foreach($customers as $customer): ?>
                        <option value="<?= $customer['id'] ?>" <?= $customer['id'] == $sale['customer_id'] ? 'selected' : '' ?>>
                            <?= esc($customer['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- PRODUCT -->
            <div class="mb-4">
                <label class="block mb-1 font-medium">Product</label>
                <select name="product_id" class="productSelect w-full border px-3 py-2 rounded" onchange="updateRow(this)" required>
                    <option value="">Select Product</option>
                    <?php foreach($products as $product): ?>
                        <option value="<?= $product['id'] ?>" 
                                <?= $product['id'] == $sale['product_id'] ? 'selected' : '' ?>
                                data-price="<?= isset($product['price']) ? $product['price'] : 0 ?>" 
                                data-stock="<?= isset($product['quantity']) ? $product['quantity'] : 0 ?>">
                            <?= esc($product['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- QUANTITY & PRICE -->
            <div class="grid sm:grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block mb-1 font-medium">Available Stock</label>
                    <input type="text" id="stockCell" class="border px-3 py-2 w-full bg-gray-100" readonly>
                </div>
                <div>
                    <label class="block mb-1 font-medium">Selling Price</label>
                    <input type="number" name="price" id="sellPrice" class="border px-3 py-2 w-full" oninput="recalculate(this)" required>
                </div>
                <div>
                    <label class="block mb-1 font-medium">Quantity</label>
                    <input type="number" name="quantity" id="qty" class="border px-3 py-2 w-full" min="1" oninput="recalculate(this)" required>
                </div>
            </div>

            <!-- TOTAL -->
            <div class="mb-4">
                <label class="block mb-1 font-medium">Total</label>
                <input type="text" id="total" class="border px-3 py-2 w-full bg-gray-100" readonly>
            </div>

            <div class="flex justify-end gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Update Sale</button>
                <a href="<?= site_url('sales') ?>" class="bg-gray-500 text-white px-4 py-2 rounded">Cancel</a>
            </div>

        </form>

    </div>
</div>

<script>
$(document).ready(function () {
    $('.customerSelect, .productSelect').select2({ width: '100%' });

    // Initialize row values on page load
    const productSelect = document.querySelector('.productSelect');
    if (productSelect.value) updateRow(productSelect);
});

function updateRow(select) {
    const opt = select.selectedOptions[0];
    const price = parseFloat(opt.dataset.price) || 0;
    const stock = parseInt(opt.dataset.stock) || 0;

    document.getElementById('sellPrice').value = price;
    document.getElementById('stockCell').value = stock;
    recalculate();
}

function recalculate() {
    const qty = parseInt(document.getElementById('qty').value) || 0;
    const price = parseFloat(document.getElementById('sellPrice').value) || 0;
    const stock = parseInt(document.getElementById('stockCell').value) || 0;

    if (qty > stock) {
        alert('Quantity exceeds available stock');
        document.getElementById('qty').value = stock;
        return;
    }

    document.getElementById('total').value = (qty * price).toFixed(2);
}
</script>

</body>
</html>
