<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<main class="max-w-3xl mx-auto px-4 mt-8">

    <!-- Back Button -->
    <div class="mb-6">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded">
            ← Back
        </a>
    </div>

    <!-- Customer & Date Form -->
    <form action="<?= site_url('sales/generateInvoice') ?>" method="GET" class="grid grid-cols-1 sm:grid-cols-4 gap-4 items-end mb-8">
        <div>
            <label class="block mb-1 font-medium text-gray-600">Select Customer</label>
            <select name="customer_id" class="border px-3 py-2 rounded w-full" required>
                <option value="">-- Choose Customer --</option>
                <?php if(!empty($customers)): ?>
                    <?php foreach($customers as $customer): ?>
                        <option value="<?= $customer['id'] ?>" <?= (isset($_GET['customer_id']) && $_GET['customer_id'] == $customer['id']) ? 'selected' : '' ?>>
                            <?= esc($customer['name']) ?>
                        </option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="">No customers found</option>
                <?php endif; ?>
            </select>
        </div>

        <div>
            <label class="block mb-1 font-medium text-gray-600">Select Date</label>
            <input type="date" name="invoice_date" class="border px-3 py-2 rounded w-full" value="<?= $_GET['invoice_date'] ?? date('Y-m-d') ?>" required>
        </div>

        <div>
            <label class="block mb-1 font-medium text-gray-600">Transportation Cost (Optional)</label>
            <input type="number" name="transport_cost" class="border px-3 py-2 rounded w-full" value="<?= $_GET['transport_cost'] ?? '' ?>" placeholder="Enter if applicable">
        </div>

        <div class="flex flex-col">
            <label class="block mb-1 font-medium text-gray-600">Include Tax?</label>
            <div class="flex items-center mt-1 gap-2">
                <input type="checkbox" name="tax" value="1" <?= isset($_GET['tax']) ? 'checked' : '' ?>>
                <span class="text-gray-700">Apply 18% Tax</span>
            </div>
            <button type="submit" class="mt-3 bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded w-full">
                Generate Invoice
            </button>
        </div>
    </form>

    <?php if(!empty($sale)): 
        // Calculate totals
        $subTotal = 0;
        foreach($sale as $item) {
            $subTotal += $item['quantity'] * $item['price'];
        }
        $transport = isset($_GET['transport_cost']) && $_GET['transport_cost'] > 0 ? (float)$_GET['transport_cost'] : 0;
        $applyTax = isset($_GET['tax']) && $_GET['tax'] == 1;
        $taxableAmount = $subTotal + $transport;
        $tax = $applyTax ? $taxableAmount * 0.18 : 0;
        $grandTotal = $taxableAmount + $tax;
    ?>

    <!-- Invoice Card -->
    <div class="bg-white rounded-2xl shadow-lg overflow-hidden p-6">

        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start border-b pb-6 mb-6 gap-4">
            <div class="flex items-start gap-4">
                <img src="<?= base_url('images/gagmo log.jpeg') ?>" alt="Logo" class="w-20">
                <div class="text-sm text-gray-700">
                    <h1 class="text-lg font-bold text-gray-800">GAGMO COMPANY Ltd</h1>
                    <p>Gamba Gibe Mondea</p>
                    <p>P.O Box. 2125, Mwanza, Tanzania</p>
                    <p>+255 673718622 | gagmocompanylimited@gmail.com</p>
                    <p>TIN: 158-577-801 | VRN: 40-317588-H</p>
                </div>
            </div>

            <div class="text-right text-sm text-gray-700">
                <h2 class="text-2xl font-bold text-green-700">Invoice</h2>
                <p>#<?= esc($sale[0]['id']) ?></p>
                <p>Date: <?= date('Y-m-d', strtotime($sale[0]['created_at'])) ?></p>
            </div>
        </div>

        <!-- Customer Info -->
        <div class="mb-6 text-sm text-gray-700">
            <h3 class="font-semibold mb-2">Bill To:</h3>
            <p><strong>Name:</strong> <?= esc($sale[0]['customer_name']) ?></p>
            <p><strong>Contact:</strong> <?= esc($sale[0]['phone']) ?></p>
            <p><strong>Address:</strong> <?= esc($sale[0]['address']) ?></p>
        </div>

        <!-- Products Table -->
        <div class="overflow-x-auto mb-6">
            <table class="min-w-full border border-gray-200 text-gray-700 text-sm">
                <thead class="bg-green-100 text-left">
                    <tr>
                        <th class="px-3 py-2 border-b">Product</th>
                        <th class="px-3 py-2 border-b">Qty</th>
                        <th class="px-3 py-2 border-b">Unit Price</th>
                        <th class="px-3 py-2 border-b">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($sale as $item): 
                        $total = $item['quantity'] * $item['price'];
                    ?>
                        <tr class="hover:bg-green-50 transition">
                            <td class="px-3 py-2 border-b"><?= esc($item['product_name']) ?></td>
                            <td class="px-3 py-2 border-b"><?= esc($item['quantity']) ?></td>
                            <td class="px-3 py-2 border-b">Tsh. <?= number_format($item['price'], 2) ?></td>
                            <td class="px-3 py-2 border-b">Tsh. <?= number_format($total, 2) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Totals -->
        <div class="flex justify-end mb-6 text-sm text-gray-700">
            <table class="text-right">
                <tr>
                    <td class="pr-4 font-semibold">Sub Total:</td>
                    <td>Tsh. <?= number_format($subTotal, 2) ?></td>
                </tr>
                <?php if($transport > 0): ?>
                <tr>
                    <td class="pr-4 font-semibold">Transportation:</td>
                    <td>Tsh. <?= number_format($transport, 2) ?></td>
                </tr>
                <?php endif; ?>
                <?php if($applyTax): ?>
                <tr>
                    <td class="pr-4 font-semibold">Taxable Amount:</td>
                    <td>Tsh. <?= number_format($taxableAmount, 2) ?></td>
                </tr>
                <tr>
                    <td class="pr-4 font-semibold">Tax (18%):</td>
                    <td>Tsh. <?= number_format($tax, 2) ?></td>
                </tr>
                <?php endif; ?>
                <tr class="font-bold bg-green-100">
                    <td class="pr-4">Grand Total:</td>
                    <td>Tsh. <?= number_format($grandTotal, 2) ?></td>
                </tr>
            </table>
        </div>

        <!-- Download Button with parameters -->
        <div class="mb-6 text-right">
            <a href="<?= site_url('sales/downloadInvoice/'.$sale[0]['id']) 
                         . '?transport_cost=' . ($transport ?? 0) 
                         . '&tax=' . ($applyTax ? 1 : 0) ?>" 
               class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded text-sm">
                Download Invoice (PDF)
            </a>
        </div>

        <!-- Payment Instructions & Signature -->
        <div class="flex flex-col sm:flex-row justify-between items-start border-t pt-6 mt-6 text-sm text-gray-700 gap-4">
            <div class="w-full sm:w-1/2 bg-green-50 p-4 rounded-lg shadow-sm">
                <h3 class="font-semibold mb-2">Payment Instructions</h3>
                <p>Account Name: <strong>GAGMO CO LTD</strong></p>
                <p>Account Number: <strong>33710017239</strong></p>
                <p>Bank: <strong>NMB</strong></p>
            </div>

            <div class="w-full sm:w-1/2 flex justify-end items-center">
                <div class="text-center">
                    <img src="<?= base_url('images/gagmo signature.jpeg') ?>" alt="Signature" class="w-32 mb-2">
                    <p class="font-semibold">Authorized Signature</p>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="mt-6 text-center text-gray-500 text-sm">
            Thank you for your business!<br>
            &copy; <?= date('Y') ?> Inventory Management System
        </div>

    </div>

    <?php elseif(isset($_GET['customer_id'])): ?>
        <p class="text-gray-600 text-center mt-6">No sales found for the selected customer and date.</p>
    <?php else: ?>
        <p class="text-gray-600 text-center mt-6">Please select a customer and date to generate the invoice.</p>
    <?php endif; ?>

</main>

</body>
</html>
