<?php
// Convert images to base64
$logo_path = FCPATH . 'images/gagmo log.jpeg';
$logo_type = pathinfo($logo_path, PATHINFO_EXTENSION);
$logo_data = file_get_contents($logo_path);
$logo_base64 = 'data:image/' . $logo_type . ';base64,' . base64_encode($logo_data);

$sig_path = FCPATH . 'images/gagmo signature.jpeg';
$sig_type = pathinfo($sig_path, PATHINFO_EXTENSION);
$sig_data = file_get_contents($sig_path);
$sig_base64 = 'data:image/' . $sig_type . ';base64,' . base64_encode($sig_data);

// Calculate totals
$subTotal = 0;
foreach ($sale as $item) {
    $subTotal += $item['quantity'] * $item['price'];
}

$transport = isset($_GET['transport_cost']) && $_GET['transport_cost'] > 0 ? (float)$_GET['transport_cost'] : 0;
$applyTax = isset($_GET['tax']) && $_GET['tax'] == 1;
$taxableAmount = $subTotal + $transport;
$tax = $applyTax ? $taxableAmount * 0.18 : 0;
$grandTotal = $taxableAmount + $tax;
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice #<?= esc($sale[0]['id']) ?></title>
<style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
        color: #111827;
        margin: 0;
        padding: 0;
        background: #ffffff;
    }

    .invoice-box {
        max-width: 820px;
        margin: 20px auto;
        padding: 24px;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        background: #fff;
    }

    .row { display: table; width: 100%; margin-bottom: 12px; }
    .col { display: table-cell; vertical-align: top; }
    .text-right { text-align: right; }
    .text-center { text-align: center; }
    .logo { width: 90px; }
    .signature { width: 140px; margin-top: 16px; }
    h1 { font-size: 22px; color: #16a34a; margin: 0; }
    h3 { margin: 0 0 6px 0; font-size: 13px; }
    .company-details { font-size: 12px; line-height: 1.5; }
    hr { border: none; border-top: 1px solid #e5e7eb; margin: 16px 0; }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table th {
        background: #dcfce7;
        padding: 8px;
        border: 1px solid #e5e7eb;
        text-align: left;
    }

    table td {
        padding: 8px;
        border: 1px solid #e5e7eb;
    }

    .totals {
        width: 320px;
        float: right;
        margin-top: 10px;
        font-size: 12px;
    }

    .totals td { padding: 6px 8px; border: none; }
    .grand-total { background: #dcfce7; font-weight: bold; }

    .payment-box {
        background: #f0fdf4;
        padding: 14px;
        width: 48%;
        font-size: 12px;
        border-radius: 8px;
    }

    .footer {
        text-align: center;
        font-size: 10px;
        color: #6b7280;
        margin-top: 16px;
    }
</style>
</head>
<body>

<div class="invoice-box">

    <!-- HEADER -->
    <div class="row">
        <div class="col" style="width:65%;">
            <img src="<?= $logo_base64 ?>" class="logo"><br>
            <div class="company-details">
                <strong>GAGMO COMPANY Ltd</strong><br>
                Gamba Gibe Mondea<br>
                P.O Box. 2125, Mwanza, Tanzania<br>
                +255 673718622 | gagmocompanylimited@gmail.com<br>
                TIN: 158-577-801 &nbsp; VRN: 40-317588-H
            </div>
        </div>

        <div class="col text-right" style="width:35%;">
            <h1>Invoice</h1>
            <strong>#<?= esc($sale[0]['id']) ?></strong><br>
            Date: <?= date('Y-m-d', strtotime($sale[0]['created_at'])) ?>
        </div>
    </div>

    <hr>

    <!-- BILL TO -->
    <h3>Bill To:</h3>
    <p>
        <strong>Name:</strong> <?= esc($sale[0]['customer_name']) ?><br>
        <strong>Contact:</strong> <?= esc($sale[0]['phone']) ?><br>
        <strong>Address:</strong> <?= esc($sale[0]['address']) ?>
    </p>

    <!-- ITEMS -->
    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th width="80">Qty</th>
                <th width="120">Unit Price</th>
                <th width="120">Total</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($sale as $item): 
            $lineTotal = $item['quantity'] * $item['price'];
        ?>
            <tr>
                <td><?= esc($item['product_name']) ?></td>
                <td><?= esc($item['quantity']) ?></td>
                <td>Tsh. <?= number_format($item['price'],2) ?></td>
                <td>Tsh. <?= number_format($lineTotal,2) ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <!-- TOTALS -->
    <table class="totals">
        <tr>
            <td>Sub Total:</td>
            <td class="text-right">Tsh. <?= number_format($subTotal,2) ?></td>
        </tr>
        <?php if($transport > 0): ?>
        <tr>
            <td>Transportation:</td>
            <td class="text-right">Tsh. <?= number_format($transport,2) ?></td>
        </tr>
        <?php endif; ?>
        <?php if($applyTax): ?>
        <tr>
            <td>Taxable Amount:</td>
            <td class="text-right">Tsh. <?= number_format($taxableAmount,2) ?></td>
        </tr>
        <tr>
            <td>Tax (18%):</td>
            <td class="text-right">Tsh. <?= number_format($tax,2) ?></td>
        </tr>
        <?php endif; ?>
        <tr class="grand-total">
            <td>Grand Total:</td>
            <td class="text-right">Tsh. <?= number_format($grandTotal,2) ?></td>
        </tr>
    </table>

    <div style="clear:both;"></div>

    <!-- PAYMENT + SIGNATURE -->
    <div class="row" style="margin-top:24px;">
        <div class="col payment-box">
            <strong>Payment Instructions</strong><br><br>
            Account Name: <strong>GAGMO CO LTD</strong><br>
            Account Number: <strong>33710017239</strong><br>
            Bank: <strong>NMB</strong>
        </div>

        <div class="col text-center">
            <img src="<?= $sig_base64 ?>" class="signature"><br>
            <strong>Authorized Signature</strong>
        </div>
    </div>

    <!-- FOOTER -->
    <div class="footer">
        Thank you for your business!<br>
        © <?= date('Y') ?> GAGMO Management System
    </div>

</div>

</body>
</html>
