<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-6">

    <!-- HEADER & SEARCH -->
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-4">
        <div class="flex gap-2 flex-wrap">
            <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded">
                ← Back
            </a>
            <input type="text" id="searchInput" placeholder="Search sales..."
                   class="border px-3 py-2 rounded w-full sm:w-64" onkeyup="searchSales()">
        </div>
        <button onclick="toggleModal('addSaleModal')"
                class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded-lg">
            + Add Sale
        </button>
    </div>

    <!-- SALES TABLE -->
    <div class="bg-white rounded-xl shadow overflow-x-auto">
        <table class="min-w-full divide-y text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left">Customer</th>
                    <th class="px-6 py-3 text-left">Product</th>
                    <th class="px-6 py-3 text-left">Qty</th>
                    <th class="px-6 py-3 text-left">Price</th>
                    <th class="px-6 py-3 text-left">Total</th>
                    <th class="px-6 py-3 text-left">Date</th>
                    <th class="px-6 py-3 text-left">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y" id="salesTableBody">
<?php if(!empty($sales)): ?>
    <?php foreach($sales as $sale): ?>
        <tr>
            <td class="px-6 py-3"><?= esc($sale['customer_name'] ?? '-') ?></td>
            <td class="px-6 py-3"><?= esc($sale['product_name'] ?? '-') ?></td>
            <td class="px-6 py-3"><?= esc($sale['quantity'] ?? 0) ?></td>
            <td class="px-6 py-3">Tsh <?= number_format($sale['price'] ?? 0,2) ?></td>
            <td class="px-6 py-3">Tsh <?= number_format(($sale['quantity'] ?? 0) * ($sale['price'] ?? 0), 2) ?></td>
            <td class="px-6 py-3"><?= isset($sale['created_at']) ? date('Y-m-d', strtotime($sale['created_at'])) : '-' ?></td>
            <td class="px-6 py-3 space-x-3">
                <button onclick="editSale(<?= $sale['id'] ?>)" class="text-blue-600 hover:text-blue-800">
                    Edit
                </button>
                <a href="<?= site_url('sales/delete/'.$sale['id']) ?>" onclick="return confirm('Are you sure?')" class="text-red-600 hover:text-red-800">
                    Delete
                </a>
            </td>
        </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr>
        <td colspan="7" class="text-center py-4">No sales found</td>
    </tr>
<?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- ADD/EDIT SALE MODAL -->
<div id="addSaleModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 overflow-auto p-4">
    <div class="bg-white rounded-xl p-6 w-full max-w-5xl shadow mx-2">

        <h2 class="text-2xl font-bold mb-4 text-center" id="modalTitle">Add Sale</h2>

        <div class="bg-blue-50 border border-blue-200 text-sm p-4 rounded mb-4">
            <ul class="list-disc ml-5 space-y-1">
                <li>Stock is shown automatically when a product is selected</li>
                <li>You may edit the selling price</li>
                <li>Price difference shows profit/loss compared to actual price</li>
                <li>You cannot sell more than available stock</li>
            </ul>
        </div>

        <form id="saleForm" action="<?= site_url('sales/store') ?>" method="POST" class="space-y-4">

            <!-- CUSTOMER + DATE -->
            <div class="grid sm:grid-cols-2 gap-4">
                <div>
                    <label class="block mb-1 font-medium">Customer *</label>
                    <select name="customer_id" class="customerSelect w-full border px-3 py-2 rounded" required>
                        <option value="">Select Customer</option>
                        <?php foreach($customers as $customer): ?>
                            <option value="<?= $customer['id'] ?>"><?= esc($customer['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div>
                    <label class="block mb-1 font-medium">Sale Date</label>
                    <input type="date" name="date" value="<?= date('Y-m-d') ?>" class="border px-3 py-2 rounded w-full">
                </div>
            </div>

            <!-- PRODUCTS TABLE -->
            <div class="overflow-x-auto">
                <table class="w-full border text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border px-2 py-2">Product</th>
                            <th class="border px-2 py-2">Stock</th>
                            <th class="border px-2 py-2">Actual Price</th>
                            <th class="border px-2 py-2">Selling Price</th>
                            <th class="border px-2 py-2">Difference</th>
                            <th class="border px-2 py-2">Qty</th>
                            <th class="border px-2 py-2">Total</th>
                            <th class="border px-2 py-2">Action</th>
                        </tr>
                    </thead>
                    <tbody id="salesRows">
                        <tr class="sales-row">
                            <td class="border px-2 py-2">
                                <select name="product_id[]" class="productSelect w-full border rounded px-2 py-1" onchange="updateRow(this)" required>
                                    <option value="">Select</option>
                                    <?php foreach($products as $product): ?>
                                        <option value="<?= $product['id'] ?>" data-price="<?= $product['price'] ?? 0 ?>" data-stock="<?= $product['quantity'] ?? 0 ?>"><?= esc($product['name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td class="border px-2 py-2 text-center stockCell">-</td>
                            <td class="border px-2 py-2"><input type="text" class="actualPrice border px-2 py-1 w-full bg-gray-100" readonly></td>
                            <td class="border px-2 py-2"><input type="number" name="price[]" class="sellPrice border px-2 py-1 w-full" oninput="recalculate(this)" required></td>
                            <td class="border px-2 py-2 text-center diffCell">0</td>
                            <td class="border px-2 py-2"><input type="number" name="quantity[]" class="qty border px-2 py-1 w-full" min="1" oninput="recalculate(this)" required></td>
                            <td class="border px-2 py-2"><input type="text" class="rowTotal border px-2 py-1 w-full bg-gray-100" readonly></td>
                            <td class="border px-2 py-2 text-center">
                                <button type="button" onclick="removeRow(this)" class="bg-red-500 text-white px-2 py-1 rounded">✕</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="flex flex-col sm:flex-row justify-between items-center mt-4 gap-4">
                <button type="button" onclick="addRow()" class="bg-indigo-500 text-white px-4 py-2 rounded">+ Add Product</button>

                <div class="flex items-center gap-2 flex-wrap">
                    <strong>Grand Total:</strong>
                    <input type="text" id="grandTotal" class="border px-3 py-2 rounded bg-gray-100 w-32" readonly>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Save Sale</button>
                    <button type="button" onclick="toggleModal('addSaleModal')" class="bg-gray-500 text-white px-4 py-2 rounded">Cancel</button>
                </div>
            </div>

        </form>
    </div>
</div>

<script>
$(document).ready(function () {
    $('.customerSelect, .productSelect').select2({ width: '100%' });
});

function toggleModal(id) {
    document.getElementById(id).classList.toggle('hidden');
}

function updateRow(select) {
    const row = select.closest('.sales-row');
    const opt = select.selectedOptions[0];
    const price = parseFloat(opt.dataset.price) || 0;
    const stock = parseInt(opt.dataset.stock) || 0;
    row.querySelector('.actualPrice').value = price;
    row.querySelector('.sellPrice').value = price;
    row.querySelector('.stockCell').innerText = stock;
    row.dataset.stock = stock;
    recalculate(select);
}

function recalculate(el) {
    const row = el.closest('.sales-row');
    const actual = parseFloat(row.querySelector('.actualPrice').value) || 0;
    const sell = parseFloat(row.querySelector('.sellPrice').value) || 0;
    let qty = parseInt(row.querySelector('.qty').value) || 0;
    const stock = parseInt(row.dataset.stock) || 0;

    if (qty > stock) {
        alert('Quantity exceeds available stock');
        qty = stock;
        row.querySelector('.qty').value = stock;
    }

    row.querySelector('.diffCell').innerText = (sell - actual).toFixed(2);
    row.querySelector('.rowTotal').value = (sell * qty).toFixed(2);
    updateGrandTotal();
}

function updateGrandTotal() {
    let total = 0;
    document.querySelectorAll('.rowTotal').forEach(i => total += parseFloat(i.value) || 0);
    document.getElementById('grandTotal').value = total.toFixed(2);
}

function addRow() {
    const row = document.querySelector('.sales-row').cloneNode(true);
    row.querySelectorAll('input').forEach(i => i.value = '');
    row.querySelector('.stockCell').innerText = '-';
    row.querySelector('.diffCell').innerText = '0';
    row.dataset.stock = 0;
    document.getElementById('salesRows').appendChild(row);
    $('.productSelect').select2({ width: '100%' });
}

function removeRow(btn) {
    if (document.querySelectorAll('.sales-row').length > 1) {
        btn.closest('.sales-row').remove();
        updateGrandTotal();
    }
}

function editSale(id) {
    window.location.href = "<?= site_url('sales/edit/') ?>" + id;
}

function searchSales() {
    const input = document.getElementById('searchInput').value.toLowerCase();
    const rows = document.querySelectorAll('#salesTableBody tr');
    rows.forEach(row => {
        const rowText = row.innerText.toLowerCase();
        row.style.display = rowText.includes(input) ? '' : 'none';
    });
}
</script>

</body>
</html>
