<?= view('header') ?>

<div class="max-w-7xl mx-auto px-6 mt-8">

    <h1 class="text-2xl font-bold text-gray-800 mb-6">New Sale</h1>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

        <!-- LEFT: PRODUCT SELECTION -->
        <div class="lg:col-span-2 bg-white rounded-xl p-6 shadow">
            <h2 class="font-semibold mb-4">Products</h2>

            <!-- Later: search / scan -->
            <input type="text"
                   placeholder="Search product..."
                   class="w-full border rounded-lg px-4 py-2 mb-4">

            <div class="text-gray-500 text-sm">
                Selected products will appear here.
            </div>
        </div>

        <!-- RIGHT: SALE SUMMARY -->
        <div class="bg-white rounded-xl p-6 shadow">
            <h2 class="font-semibold mb-4">Summary</h2>

            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span>Subtotal</span>
                    <span>0.00</span>
                </div>
                <div class="flex justify-between">
                    <span>Discount</span>
                    <span>0.00</span>
                </div>
                <div class="flex justify-between font-bold">
                    <span>Total</span>
                    <span>0.00</span>
                </div>
            </div>

            <button class="mt-6 w-full bg-green-600 text-white py-2 rounded-lg hover:bg-green-700">
                Complete Sale
            </button>
        </div>

    </div>
</div>

<?= view('footer') ?>









<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
</head>

<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-7xl mx-auto px-6 mt-6">

    <!-- HEADER -->
    <div class="flex justify-between items-center mb-6">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-600 text-white px-4 py-2 rounded">
            ← Back
        </a>

        <button onclick="toggleModal('addSaleModal')"
                class="bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded-lg">
            + Add Sale
        </button>
    </div>

    <!-- FLASH -->
    <?php if(session()->getFlashdata('success')): ?>
        <div class="mb-4 bg-green-100 text-green-700 px-4 py-3 rounded">
            <?= session()->getFlashdata('success') ?>
        </div>
    <?php endif; ?>

    <?php if(session()->getFlashdata('error')): ?>
        <div class="mb-4 bg-red-100 text-red-700 px-4 py-3 rounded">
            <?= session()->getFlashdata('error') ?>
        </div>
    <?php endif; ?>

    <!-- SALES TABLE -->
    <div class="bg-white rounded-xl shadow overflow-hidden">
        <table class="min-w-full divide-y">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left">Customer</th>
                    <th class="px-6 py-3 text-left">Product</th>
                    <th class="px-6 py-3 text-left">Qty</th>
                    <th class="px-6 py-3 text-left">Price</th>
                    <th class="px-6 py-3 text-left">Total</th>
                    <th class="px-6 py-3 text-left">Date</th>
                    <th class="px-6 py-3 text-left">Actions</th>
                </tr>
            </thead>

            <tbody class="divide-y">
            <?php if(!empty($sales)): ?>
                <?php foreach($sales as $sale): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-3"><?= esc($sale['customer_name']) ?></td>
                        <td class="px-6 py-3"><?= esc($sale['product_name']) ?></td>
                        <td class="px-6 py-3"><?= esc($sale['quantity']) ?></td>
                        <td class="px-6 py-3">Tsh <?= number_format($sale['price'],2) ?></td>
                        <td class="px-6 py-3">Tsh <?= number_format($sale['total'],2) ?></td>
                        <td class="px-6 py-3"><?= date('Y-m-d', strtotime($sale['created_at'])) ?></td>
                        <td class="px-6 py-3 space-x-3">
                            <button onclick="viewSale(<?= $sale['id'] ?>)"
                                    class="text-blue-600 hover:text-blue-800">
                                View
                            </button>
                            <a href="<?= site_url('sales/delete/'.$sale['id']) ?>"
                               onclick="return confirm('Are you sure?')"
                               class="text-red-600 hover:text-red-800">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                        No sales found
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>

        <?php if ($pager && $pager->getPageCount() > 1): ?>
            <div class="mt-4 px-6 py-3 flex justify-center">
                <?= $pager->links() ?>
            </div>
        <?php endif; ?>
    </div>

</div>

<!-- ADD SALE MODAL -->
<div id="addSaleModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 overflow-auto">
    <div class="bg-white rounded-xl p-6 w-full max-w-4xl shadow mx-2">
        <h2 class="text-2xl font-bold mb-4 text-center">Add Sale</h2>

        <form action="<?= site_url('sales/store') ?>" method="POST" id="salesForm" class="space-y-4">

            <!-- CUSTOMER + DATE -->
            <div class="grid sm:grid-cols-2 gap-4">
                <div>
                    <label class="block mb-1 font-medium">Customer *</label>
                    <select name="customer_id" class="customerSelect w-full border px-3 py-2 rounded" required>
                        <option value="">Select Customer</option>
                        <?php foreach($customers as $customer): ?>
                            <option value="<?= $customer['id'] ?>"><?= esc($customer['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div>
                    <label class="block mb-1 font-medium">Sale Date</label>
                    <input type="date" name="date"
                           value="<?= date('Y-m-d') ?>"
                           class="border px-3 py-2 rounded w-full">
                </div>
            </div>

            <!-- SALES ROW -->
            <div id="salesRows" class="space-y-3">
                <div class="grid sm:grid-cols-6 gap-2 sales-row items-end">

                    <select name="product_id[]" class="productSelect border px-3 py-2 rounded w-full"
                            onchange="updateRow(this)" required>
                        <option value="">Select Product</option>
                        <?php foreach($products as $product): ?>
                            <option value="<?= $product['id'] ?>"
                                    data-price="<?= $product['price'] ?>"
                                    data-stock="<?= $product['quantity'] ?>">
                                <?= esc($product['name']) ?> (Stock: <?= $product['quantity'] ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>

                    <input type="text" class="stockInput border px-3 py-2 rounded bg-gray-100 text-center" readonly placeholder="Stock">
                    <input type="number" name="price[]" class="priceInput border px-3 py-2 rounded" readonly>
                    <input type="number" name="quantity[]" class="quantityInput border px-3 py-2 rounded" min="1" oninput="updateRowTotal(this)" required>
                    <input type="text" class="totalInput border px-3 py-2 rounded bg-gray-100" readonly>

                    <button type="button" onclick="removeRow(this)"
                            class="bg-red-500 text-white px-3 py-2 rounded">✕</button>
                </div>
            </div>

            <button type="button" onclick="addRow()" class="bg-indigo-500 text-white px-4 py-2 rounded">
                + Add Another Product
            </button>

            <div class="flex justify-end gap-3 items-center">
                <label class="font-semibold">Grand Total:</label>
                <input type="text" id="grandTotal" class="border px-3 py-2 rounded bg-gray-100 w-36" readonly>
            </div>

            <div class="flex justify-end gap-3">
                <button type="button" onclick="toggleModal('addSaleModal')"
                        class="bg-gray-500 text-white px-4 py-2 rounded">
                    Cancel
                </button>
                <button class="bg-blue-500 text-white px-4 py-2 rounded">
                    Save Sale
                </button>
            </div>

        </form>
    </div>
</div>

<script>
$(document).ready(function () {
    $('.customerSelect, .productSelect').select2({ width: '100%' });
});

function toggleModal(id) {
    document.getElementById(id).classList.toggle('hidden');
}

function addRow() {
    const row = document.querySelector('.sales-row').cloneNode(true);
    row.querySelectorAll('input').forEach(i => i.value = '');
    row.querySelector('select').selectedIndex = 0;
    document.getElementById('salesRows').appendChild(row);
    $('.productSelect').select2({ width: '100%' });
}

function removeRow(btn) {
    if (document.querySelectorAll('.sales-row').length > 1) {
        btn.closest('.sales-row').remove();
        updateGrandTotal();
    }
}

function updateRow(select) {
    const row = select.closest('.sales-row');
    const option = select.selectedOptions[0];
    row.querySelector('.priceInput').value = option.dataset.price || 0;
    row.querySelector('.stockInput').value = option.dataset.stock || 0;
    row.querySelector('.quantityInput').value = '';
    row.querySelector('.totalInput').value = '';
    updateGrandTotal();
}

function updateRowTotal(el) {
    const row = el.closest('.sales-row');
    const price = parseFloat(row.querySelector('.priceInput').value) || 0;
    const qty = parseInt(row.querySelector('.quantityInput').value) || 0;
    row.querySelector('.totalInput').value = (price * qty).toFixed(2);
    updateGrandTotal();
}

function updateGrandTotal() {
    let total = 0;
    document.querySelectorAll('.totalInput').forEach(i => {
        const val = parseFloat(i.value);
        if (!isNaN(val)) total += val;
    });
    document.getElementById('grandTotal').value = total.toFixed(2);
}
</script>

</body>
</html>
