<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Sales Payments</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto mt-8">

    <!-- Page Header -->
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <a href="<?= site_url('dashboard') ?>"
           class="bg-gray-600 text-white px-3 py-1.5 rounded hover:bg-gray-700 text-sm">← Back</a>
        <h2 class="text-2xl font-bold">Sales Payments</h2>
    </div>

    <!-- Alerts -->
    <?php if (!empty($success)): ?>
        <div class="bg-green-100 text-green-700 p-3 rounded mb-4"><?= esc($success) ?></div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
        <div class="bg-red-100 text-red-700 p-3 rounded mb-4"><?= esc($error) ?></div>
    <?php endif; ?>

    <!-- Payment Form -->
    <form action="<?= site_url('sales-payments/store') ?>" method="POST" 
          class="grid grid-cols-1 md:grid-cols-5 gap-4 mb-6 p-6 rounded-xl shadow-md bg-blue-50">

        <!-- Searchable Select -->
        <div class="relative">
            <label class="block mb-1 font-semibold text-sm">Customer</label>
            <div id="customSelect" class="border p-1.5 rounded cursor-pointer bg-white relative text-sm">
                <span id="selectedOption">Select Customer</span>
                <svg class="w-4 h-4 absolute right-2 top-1/2 -translate-y-1/2 pointer-events-none" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                </svg>

                <!-- Dropdown -->
                <div id="optionsContainer" class="absolute top-full left-0 w-full border mt-1 rounded bg-white shadow max-h-60 overflow-y-auto hidden z-50">
                    <input type="text" id="searchOption" placeholder="Search..." class="w-full p-1.5 border-b focus:outline-none text-sm" />
                    <ul id="optionsList" class="text-sm">
                        <li data-value="" class="p-2 hover:bg-gray-100 cursor-pointer">Select Customer</li>
                        <?php foreach ($sales as $sale): ?>
                        <li data-value="<?= $sale['customer_id'] ?>" class="p-2 hover:bg-gray-100 cursor-pointer">
                            <?= esc($sale['customer_name']) ?> (Balance: <?= number_format($sale['balance'],2) ?>)
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <input type="hidden" name="sale_id" id="hiddenSaleId" required>
        </div>

        <!-- Amount Paid -->
        <div>
            <label class="block mb-1 font-semibold text-sm">Amount Paid</label>
            <input type="number" step="0.01" name="amount" required placeholder="Enter amount" 
                   class="border p-1.5 rounded text-sm w-full">
        </div>

        <!-- Payment Date -->
        <div>
            <label class="block mb-1 font-semibold text-sm">Payment Date</label>
            <input type="date" name="payment_date" value="<?= date('Y-m-d') ?>" 
                   class="border p-1.5 rounded text-sm w-full">
        </div>

        <!-- Note -->
        <div>
            <label class="block mb-1 font-semibold text-sm">Note</label>
            <textarea name="note" placeholder="Optional note" rows="1" 
                      class="border p-1.5 rounded text-sm w-full resize-none"></textarea>
        </div>

        <!-- Add Payment Button -->
        <div class="flex items-end">
            <button type="submit" class="bg-blue-600 text-white px-3 py-1.5 rounded hover:bg-blue-700 text-sm w-full">Add Payment</button>
        </div>
    </form>

    <!-- Payments Table -->
    <div class="overflow-x-auto">
        <table class="w-full border bg-white text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Customer</th>
                    <th class="border p-2">Amount Paid</th>
                    <th class="border p-2">Date</th>
                    <th class="border p-2">Note</th>
                    <th class="border p-2 text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($payments)): ?>
                    <?php foreach ($payments as $p): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="border p-2"><?= esc($p['customer_name']) ?></td>
                            <td class="border p-2 text-green-600 font-semibold"><?= number_format($p['amount'], 2) ?></td>
                            <td class="border p-2"><?= date('Y-m-d', strtotime($p['created_at'])) ?></td>
                            <td class="border p-2"><?= esc($p['note'] ?? '-') ?></td>
                            <td class="border p-2 text-center space-x-2">
                                <!-- View Icon now uses customer_id to open correct sales -->
                                <a href="<?= site_url('sales-payments/view/'.$p['customer_id']) ?>" 
                                   class="text-blue-600 hover:text-blue-800 font-bold text-lg" title="View">view</a>
                                <!-- Delete X -->
                                <a href="<?= site_url('sales-payments/delete/'.$p['id']) ?>" 
                                   onclick="return confirm('Delete payment?')" 
                                   class="text-red-600 hover:text-red-800 font-bold text-lg" title="Delete">✕</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center p-4 text-gray-500">No payments found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

<!-- JS for Searchable Select -->
<script>
const customSelect = document.getElementById('customSelect');
const optionsContainer = document.getElementById('optionsContainer');
const searchOption = document.getElementById('searchOption');
const optionsList = Array.from(document.querySelectorAll('#optionsList li'));
const selectedOption = document.getElementById('selectedOption');
const hiddenSaleId = document.getElementById('hiddenSaleId');

// Toggle dropdown on click
customSelect.addEventListener('click', () => {
    optionsContainer.classList.toggle('hidden');
    searchOption.value = '';
    filterOptions('');
    searchOption.focus();
});

// Filter options as user types
searchOption.addEventListener('input', (e) => {
    filterOptions(e.target.value);
});

function filterOptions(query) {
    const filter = query.toLowerCase();
    optionsList.forEach(option => {
        option.style.display = option.textContent.toLowerCase().includes(filter) ? 'block' : 'none';
    });
}

// Select option
optionsList.forEach(option => {
    option.addEventListener('click', () => {
        selectedOption.textContent = option.textContent;
        hiddenSaleId.value = option.dataset.value;
        optionsContainer.classList.add('hidden');
    });
});

// Close dropdown if clicked outside
document.addEventListener('click', function(event) {
    if(!customSelect.contains(event.target)) {
        optionsContainer.classList.add('hidden');
    }
});
</script>

</body>
</html>
