<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Sale Details</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto mt-8 bg-white p-6 rounded-xl shadow">

    <a href="<?= site_url('sales-payments') ?>"
       class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 mb-6 inline-block">
        ← Back
    </a>

    <h2 class="text-2xl font-bold mt-4 mb-6">Sale Details</h2>

    <!-- Sale Info -->
    <div class="mb-6">
        <p><strong>Customer:</strong> <?= esc($customer['name']) ?></p>
        <p><strong>Total Amount:</strong> <?= number_format($totalAmount, 2) ?></p>
        <p><strong>Amount Paid:</strong> <?= number_format($totalPaid, 2) ?></p>
        <p><strong>Balance:</strong> <?= number_format($balance, 2) ?></p>
    </div>

    <!-- Products Table -->
    <h3 class="text-xl font-semibold mb-2">Products</h3>
    <div class="overflow-x-auto mb-6">
        <table class="w-full border text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Product</th>
                    <th class="border p-2">Quantity</th>
                    <th class="border p-2">Price</th>
                    <th class="border p-2">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($saleProducts as $prod): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="border p-2"><?= esc($prod['name']) ?></td>
                        <td class="border p-2"><?= esc($prod['quantity']) ?></td>
                        <td class="border p-2"><?= number_format($prod['price'], 2) ?></td>
                        <td class="border p-2"><?= number_format($prod['total'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Payments Table -->
    <h3 class="text-xl font-semibold mb-2">Payments</h3>
    <div class="overflow-x-auto">
        <table class="w-full border text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border p-2">Amount</th>
                    <th class="border p-2">Date</th>
                    <th class="border p-2">Note</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($salePayments)): ?>
                    <?php foreach ($salePayments as $p): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="border p-2 text-green-600 font-semibold">
                                <?= number_format($p['amount'], 2) ?>
                            </td>
                            <td class="border p-2"><?= date('Y-m-d', strtotime($p['created_at'])) ?></td>
                            <td class="border p-2"><?= esc($p['note'] ?? '-') ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" class="text-center p-4 text-gray-500">
                            No payments recorded for this customer.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
