<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Vendors</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>

    <script>
        function toggleModal() {
            document.getElementById('vendorModal').classList.toggle('hidden');
        }
    </script>
</head>

<body class="bg-gradient-to-br from-gray-100 via-slate-100 to-gray-200 min-h-screen">

<!-- Top Navbar -->
<nav class="bg-white/80 backdrop-blur shadow-lg px-8 py-4 flex justify-between items-center sticky top-0 z-50">
    <div class="text-2xl font-extrabold text-blue-600 tracking-wide">
        Inventory Management
    </div>

    <div class="flex items-center gap-6">
        <span class="text-gray-700 font-medium">
            👋 Hello, <span class="font-semibold"><?= session()->get('name') ?></span>
        </span>
        <a href="<?= site_url('logout') ?>"
           class="bg-red-500 hover:bg-red-600 text-white px-5 py-2 rounded-lg shadow transition">
            Logout
        </a>
    </div>
</nav>

<!-- Main Content -->
<div class="max-w-5xl mx-auto mt-10 px-4">

    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center gap-4">
            <a href="<?= site_url('dashboard') ?>"
               class="text-gray-600 hover:text-blue-600 font-medium transition">
                ← Back
            </a>
            <h2 class="text-3xl font-bold text-gray-800">Vendors</h2>
        </div>

        <button onclick="toggleModal()"
                class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg shadow transition">
            + Add Vendor
        </button>
    </div>

    <!-- Vendors Table -->
    <div class="bg-white shadow-xl rounded-xl overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-100">
                <tr>
                    <th class="p-4 text-left text-sm font-semibold text-gray-600">Vendor Name</th>
                    <th class="p-4 text-left text-sm font-semibold text-gray-600">Phone</th>
                    <th class="p-4 text-center text-sm font-semibold text-gray-600">Action</th>
                </tr>
            </thead>

            <tbody>
                <?php if (empty($vendors)): ?>
                    <tr>
                        <td colspan="3" class="p-6 text-center text-gray-500">
                            No vendors added yet.
                        </td>
                    </tr>
                <?php endif; ?>

                <?php foreach ($vendors as $v): ?>
                <tr class="border-t hover:bg-gray-50 transition">
                    <td class="p-4 font-medium text-gray-800">
                        <?= esc($v['name']) ?>
                    </td>
                    <td class="p-4 text-gray-700">
                        <?= esc($v['phone'] ?? '-') ?>
                    </td>
                    <td class="p-4 text-center">
                        <a href="<?= site_url('vendors/delete/'.$v['id']) ?>"
                           onclick="return confirm('Delete this vendor?')"
                           class="text-red-600 hover:text-red-800 font-medium">
                            Delete
                        </a>
                    </td>
                </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    </div>
</div>

<!-- ADD VENDOR MODAL -->
<div id="vendorModal" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
    <div class="bg-white p-6 rounded-xl w-full max-w-md shadow-2xl relative">

        <h3 class="text-2xl font-bold text-gray-800 mb-5">Add Vendor</h3>

        <button onclick="toggleModal()"
                class="absolute top-4 right-4 text-gray-400 hover:text-gray-600 text-xl">
            ×
        </button>

        <form method="post" action="<?= site_url('vendors/store') ?>" class="space-y-4">

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">
                    Vendor Name <span class="text-red-500">*</span>
                </label>
                <input name="name" required
                       class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">
                    Phone (optional)
                </label>
                <input name="phone"
                       class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400">
            </div>

            <div class="flex justify-end gap-3 pt-4">
                <button type="button" onclick="toggleModal()"
                        class="px-4 py-2 bg-gray-300 rounded-lg hover:bg-gray-400 transition">
                    Cancel
                </button>
                <button
                        class="px-5 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                    Save Vendor
                </button>
            </div>

        </form>
    </div>
</div>

</body>
</html>
