<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Users</title>
<script src="https://cdn.tailwindcss.com"></script>

<script>
function toggleModal(modalID){
    document.getElementById(modalID).classList.toggle('hidden');
}

function openEditModal(id, name, email, role) {
    document.getElementById('editUserName').value = name;
    document.getElementById('editUserEmail').value = email;
    document.getElementById('editUserRole').value = role;
    document.getElementById('editUserForm').action = '<?= site_url('users/update') ?>/' + id;
    toggleModal('editUserModal');
}
</script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto mt-6 px-4">

    <div class="flex flex-col sm:flex-row justify-between gap-4 mb-4">
        <a href="<?= site_url('dashboard') ?>" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded text-sm">← Back</a>
        <button onclick="toggleModal('addUserModal')" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded text-sm">+ Add New User</button>
    </div>

    <div class="bg-white shadow rounded-lg overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left">ID</th>
                    <th class="px-4 py-2 text-left">Name</th>
                    <th class="px-4 py-2 text-left">Email</th>
                    <th class="px-4 py-2 text-left">Role</th>
                    <th class="px-4 py-2 text-left">Status</th>
                    <th class="px-4 py-2 text-left">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                <tr class="hover:bg-gray-50 <?= $user['status']=='banned' ? 'bg-red-50' : '' ?>">
                    <td class="px-4 py-2"><?= $user['id'] ?></td>
                    <td class="px-4 py-2"><?= esc($user['name']) ?></td>
                    <td class="px-4 py-2"><?= esc($user['email']) ?></td>
                    <td class="px-4 py-2 capitalize"><?= esc($user['role']) ?></td>
                    <td class="px-4 py-2 capitalize"><?= esc($user['status']) ?></td>
                    <td class="px-4 py-2 flex gap-2">

                        <!-- Edit -->
                        <button onclick="openEditModal(<?= $user['id'] ?>,'<?= esc($user['name'],'js') ?>','<?= esc($user['email'],'js') ?>','<?= esc($user['role'],'js') ?>')" class="text-indigo-600 hover:underline">Edit</button>

                        <!-- Delete -->
                        <a href="<?= site_url('users/delete/'.$user['id']) ?>" onclick="return confirm('Delete this user?')" class="text-red-600 hover:underline">Delete</a>

                        <!-- Ban/Unban (only normal users) -->
                        <?php if ($user['role'] !== 'manager'): ?>
                            <?php if ($user['status']=='active'): ?>
                                <a href="<?= site_url('users/ban/'.$user['id']) ?>" onclick="return confirm('Ban this user?')" class="text-orange-600 hover:underline">Ban</a>
                            <?php else: ?>
                                <a href="<?= site_url('users/unban/'.$user['id']) ?>" onclick="return confirm('Unban this user?')" class="text-green-600 hover:underline">Unban</a>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="text-gray-400">Cannot ban</span>
                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add User Modal -->
<div id="addUserModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50">
    <div class="bg-white w-full max-w-md rounded-lg p-6 relative">
        <h2 class="text-xl font-bold mb-4">Add User</h2>
        <button onclick="toggleModal('addUserModal')" class="absolute top-3 right-3 text-xl">&times;</button>
        <form action="<?= site_url('users/store') ?>" method="post" class="space-y-4">
            <input type="text" name="name" placeholder="Full name" required class="w-full border px-4 py-2 rounded">
            <input type="email" name="email" placeholder="Email" required class="w-full border px-4 py-2 rounded">
            <input type="password" name="password" placeholder="Password" required class="w-full border px-4 py-2 rounded">
            <select name="role" required class="w-full border px-4 py-2 rounded">
                <option value="">Select Role</option>
                <option value="manager">Manager</option>
                <option value="user">User</option>
            </select>
            <div class="flex justify-end gap-2">
                <button type="reset" class="bg-gray-400 text-white px-4 py-2 rounded">Reset</button>
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Add</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit User Modal -->
<div id="editUserModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50">
    <div class="bg-white w-full max-w-md rounded-lg p-6 relative">
        <h2 class="text-xl font-bold mb-4">Edit User</h2>
        <button onclick="toggleModal('editUserModal')" class="absolute top-3 right-3 text-xl">&times;</button>
        <form id="editUserForm" method="post" class="space-y-4">
            <input type="text" name="name" id="editUserName" required class="w-full border px-4 py-2 rounded">
            <input type="email" name="email" id="editUserEmail" required class="w-full border px-4 py-2 rounded">
            <select name="role" id="editUserRole" required class="w-full border px-4 py-2 rounded">
                <option value="manager">Manager</option>
                <option value="user">User</option>
            </select>
            <input type="password" name="password" placeholder="New password (optional)" class="w-full border px-4 py-2 rounded">
            <div class="flex justify-end gap-2">
                <button type="button" onclick="toggleModal('editUserModal')" class="bg-gray-400 text-white px-4 py-2 rounded">Cancel</button>
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Update</button>
            </div>
        </form>
    </div>
</div>

</body>
</html>
