<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendors</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<?= view('header'); ?>

<div class="max-w-6xl mx-auto px-4 sm:px-6 mt-6">

    <!-- Page Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">

        <!-- Left: Back + Search -->
        <div class="flex flex-col sm:flex-row sm:items-center sm:gap-3 w-full sm:w-auto">

            <!-- Back Button -->
            <a href="<?= site_url('dashboard') ?>"
               class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm mb-2 sm:mb-0 w-full sm:w-auto text-center">
                ← Back
            </a>

            <!-- Search -->
            <form method="get" class="flex gap-2 w-full sm:w-auto">
                <input type="text"
                       name="search"
                       value="<?= esc($search) ?>"
                       placeholder="Search vendors..."
                       class="border border-gray-300 px-3 py-2 rounded-lg flex-1 focus:ring-2 focus:ring-blue-400 focus:outline-none text-sm">
                <button type="submit"
                        class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm">
                    Search
                </button>
            </form>

        </div>

        <!-- Right: Add Vendor + Download PDF -->
        <div class="flex flex-col sm:flex-row gap-2 w-full sm:w-auto">
            <button onclick="toggleModal('addVendorModal')" 
                    class="inline-flex items-center justify-center gap-2 bg-blue-500 hover:bg-blue-600 text-white px-5 py-2 rounded-lg shadow w-full sm:w-auto text-sm">
                <span class="text-lg leading-none">+</span> Add Vendor
            </button>

            <a href="<?= site_url('vendors/download') ?>"
               class="inline-flex items-center justify-center gap-2 bg-green-500 hover:bg-green-600 text-white px-5 py-2 rounded-lg shadow w-full sm:w-auto text-sm">
                <span class="text-lg leading-none">⬇️</span> Download PDF
            </a>
        </div>
    </div>

    <!-- Flash Messages -->
    <?php if(!empty($success)): ?>
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg text-sm">
            <?= $success ?>
        </div>
    <?php endif; ?>

    <?php if(!empty($errors)): ?>
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg text-sm">
            <?php if(is_array($errors)): ?>
                <ul class="list-disc pl-5">
                    <?php foreach($errors as $err): ?>
                        <li><?= esc($err) ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <?= esc($errors) ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Vendors Table -->
    <div class="bg-white shadow rounded-xl overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold text-gray-600">#</th>
                    <th class="px-4 py-3 text-left font-semibold text-gray-600">Name</th>
                    <th class="px-4 py-3 text-left font-semibold text-gray-600">Phone</th>
                    <th class="px-4 py-3 text-left font-semibold text-gray-600">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php foreach($vendors as $index => $vendor): ?>
                <tr class="hover:bg-gray-50 transition">
                    <td class="px-4 py-3"><?= $index + 1 ?></td>
                    <td class="px-4 py-3 font-medium text-gray-800"><?= esc($vendor['name']) ?></td>
                    <td class="px-4 py-3 text-gray-600"><?= esc($vendor['phone'] ?? '-') ?></td>
                    <td class="px-4 py-3 flex flex-wrap gap-2">
                        <button onclick="viewVendor(<?= $vendor['id'] ?>)"
                                class="text-blue-600 hover:text-blue-800 font-medium text-sm">
                            View
                        </button>
                        <a href="<?= site_url('vendors/delete/'.$vendor['id']) ?>"
                           onclick="return confirm('Are you sure?')"
                           class="text-red-600 hover:text-red-800 font-medium text-sm">
                            Delete
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if ($pager && $pager->getPageCount() > 1): ?>
    <div class="mt-6 flex justify-center">
        <nav class="inline-flex -space-x-px rounded-md shadow-sm" aria-label="Pagination">
            <?php if ($pager->hasPrevious()): ?>
                <a href="<?= $pager->getPrevious() ?>" class="px-3 py-2 rounded-l-md border border-gray-300 bg-white text-gray-500 hover:bg-gray-50 text-sm">
                    Previous
                </a>
            <?php endif; ?>

            <?php foreach ($pager->links() as $link): ?>
                <a href="<?= $link['uri'] ?>" class="px-3 py-2 border border-gray-300 <?= $link['active'] ? 'bg-blue-500 text-white' : 'bg-white text-gray-700 hover:bg-gray-50' ?> text-sm">
                    <?= $link['title'] ?>
                </a>
            <?php endforeach; ?>

            <?php if ($pager->hasNext()): ?>
                <a href="<?= $pager->getNext() ?>" class="px-3 py-2 rounded-r-md border border-gray-300 bg-white text-gray-500 hover:bg-gray-50 text-sm">
                    Next
                </a>
            <?php endif; ?>
        </nav>
    </div>
    <?php endif; ?>

</div>

<!-- Add Vendor Modal -->
<div id="addVendorModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4">
    <div class="bg-white rounded-xl p-6 w-full max-w-md shadow-lg">
        <h2 class="text-2xl font-bold mb-4 text-center">Add Vendor</h2>
        <form action="<?= site_url('vendors/store') ?>" method="POST" class="space-y-4">
            <input type="text" name="name" required placeholder="Name" class="w-full border px-3 py-2 rounded-lg text-sm">
            <input type="text" name="phone" placeholder="Phone" class="w-full border px-3 py-2 rounded-lg text-sm">
            <input type="text" name="address" placeholder="Address" class="w-full border px-3 py-2 rounded-lg text-sm">
            <div class="flex flex-col sm:flex-row justify-end gap-2">
                <button type="button" onclick="toggleModal('addVendorModal')" class="bg-gray-400 hover:bg-gray-500 text-white px-4 py-2 rounded-lg w-full sm:w-auto text-sm">Cancel</button>
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg w-full sm:w-auto text-sm">Save</button>
            </div>
        </form>
    </div>
</div>

<!-- View Vendor Modal -->
<div id="viewVendorModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4">
    <div class="bg-white rounded-xl p-6 w-full max-w-md shadow-lg">
        <h2 class="text-2xl font-bold mb-4 text-center">Vendor Details</h2>
        <div class="space-y-2 text-gray-700 text-sm">
            <p><strong>Name:</strong> <span id="vendorName"></span></p>
            <p><strong>Phone:</strong> <span id="vendorPhone"></span></p>
            <p><strong>Address:</strong> <span id="vendorAddress"></span></p>
        </div>
        <div class="text-xs text-gray-500 mt-4">
            <p><strong>Created:</strong> <span id="vendorCreated"></span></p>
            <p><strong>Updated:</strong> <span id="vendorUpdated"></span></p>
        </div>
        <button onclick="toggleModal('viewVendorModal')" class="mt-5 bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg w-full text-sm">
            Close
        </button>
    </div>
</div>

<script>
function toggleModal(id) {
    document.getElementById(id).classList.toggle('hidden');
}

function viewVendor(id) {
    fetch('<?= site_url('vendors/view') ?>/' + id)
        .then(res => res.json())
        .then(data => {
            document.getElementById('vendorName').innerText = data.name;
            document.getElementById('vendorPhone').innerText = data.phone || '-';
            document.getElementById('vendorAddress').innerText = data.address || '-';
            document.getElementById('vendorCreated').innerText = new Date(data.created_at).toLocaleString();
            document.getElementById('vendorUpdated').innerText = new Date(data.updated_at).toLocaleString();
            toggleModal('viewVendorModal');
        })
        .catch(() => alert('Failed to load vendor info'));
}
</script>

</body>
</html>
