<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendor Items - <?= esc($vendor['name']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">

    <?= view('header'); ?>

    <div class="max-w-6xl mx-auto mt-6 px-4 sm:px-6 lg:px-8">

        <!-- Page Header -->
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
            <a href="<?= site_url('payments') ?>"
               class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm w-full sm:w-auto text-center">
               ← Back
            </a>
            <h2 class="text-xl sm:text-2xl font-bold text-center flex-1"><?= esc($vendor['name']) ?> - Purchases & Payments</h2>
        </div>

        <!-- PURCHASES TABLE -->
        <h3 class="text-lg font-semibold mb-2">Purchases</h3>
        <div class="overflow-x-auto mb-6">
            <table class="min-w-full border text-sm sm:text-base table-auto">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border px-2 py-2 text-left">Item</th>
                        <th class="border px-2 py-2 text-right">Price</th>
                        <th class="border px-2 py-2 text-right">Quantity</th>
                        <th class="border px-2 py-2 text-right">Total</th>
                        <th class="border px-2 py-2 text-left">Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($purchases)): ?>
                        <?php foreach ($purchases as $item): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="border px-2 py-2"><?= esc($item['product_name'] ?? 'N/A') ?></td>
                                <td class="border px-2 py-2 text-right"><?= number_format($item['price'] ?? 0, 2) ?></td>
                                <td class="border px-2 py-2 text-right"><?= esc($item['quantity'] ?? 0) ?></td>
                                <td class="border px-2 py-2 text-right"><?= number_format(($item['price'] ?? 0) * ($item['quantity'] ?? 0), 2) ?></td>
                                <td class="border px-2 py-2"><?= esc($item['created_at'] ?? '-') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center p-4 text-gray-500">No purchases found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- PAYMENTS TABLE -->
        <h3 class="text-lg font-semibold mb-2">Payments</h3>
        <div class="overflow-x-auto mb-4">
            <table class="min-w-full border text-sm sm:text-base table-auto">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border px-2 py-2 text-right">Amount</th>
                        <th class="border px-2 py-2 text-left">Date</th>
                        <th class="border px-2 py-2 text-left">Note</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($payments)): ?>
                        <?php foreach ($payments as $p): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="border px-2 py-2 text-right"><?= number_format($p['amount'] ?? 0, 2) ?></td>
                                <td class="border px-2 py-2"><?= esc($p['payment_date'] ?? '-') ?></td>
                                <td class="border px-2 py-2"><?= esc($p['note'] ?? '-') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="text-center p-4 text-gray-500">No payments found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- TOTAL BALANCE -->
        <?php
            $totalPurchases = array_sum(array_map(fn($i) => ($i['price'] ?? 0) * ($i['quantity'] ?? 0), $purchases));
            $totalPayments  = array_sum(array_map(fn($p) => $p['amount'] ?? 0, $payments));
            $balance        = $totalPurchases - $totalPayments;
        ?>
        <div class="mt-4 p-4 bg-gray-100 rounded text-right font-bold text-sm sm:text-base flex flex-col sm:flex-row sm:justify-end gap-2">
            <span>Total Purchases: <?= number_format($totalPurchases, 2) ?></span>
            <span>Total Payments: <?= number_format($totalPayments, 2) ?></span>
            <span class="<?= $balance < 0 ? 'text-red-600' : 'text-green-600' ?>">Balance: <?= number_format($balance, 2) ?></span>
        </div>

    </div>

</body>
</html>
